/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.config;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.tool.constant.SystemConstant;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@AutoConfiguration
@EnableConfigurationProperties(value={BladeProperties.class})
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
public class BladeBootAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BladeBootAutoConfiguration.class);
    private BladeProperties bladeProperties;

    @Bean
    public SystemConstant fileConst() {
        SystemConstant me = SystemConstant.me();
        me.setDevMode("dev".equals(this.bladeProperties.getEnv()));
        me.setDomain(this.bladeProperties.get("upload-domain", "http://localhost:8888"));
        me.setRemoteMode(this.bladeProperties.getBoolean("remote-mode", Boolean.valueOf(true)).booleanValue());
        me.setRemotePath(this.bladeProperties.get("remote-path", System.getProperty("user.dir") + "/work/blade"));
        me.setUploadPath(this.bladeProperties.get("upload-path", "/upload"));
        me.setDownloadPath(this.bladeProperties.get("download-path", "/download"));
        me.setCompress(this.bladeProperties.getBoolean("compress", Boolean.valueOf(false)).booleanValue());
        me.setCompressScale(this.bladeProperties.getDouble("compress-scale", Double.valueOf(2.0)));
        me.setCompressFlag(this.bladeProperties.getBoolean("compress-flag", Boolean.valueOf(false)).booleanValue());
        return me;
    }

    @Generated
    public BladeBootAutoConfiguration(BladeProperties bladeProperties) {
        this.bladeProperties = bladeProperties;
    }
}

