/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.launch.props;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.launch.props.BladePropertySource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BladePropertySourcePostProcessor
implements BeanFactoryPostProcessor,
InitializingBean,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(BladePropertySourcePostProcessor.class);
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final List<PropertySourceLoader> propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        log.info("BladePropertySourcePostProcessor process @BladePropertySource bean.");
        Map beansWithAnnotation = beanFactory.getBeansWithAnnotation(BladePropertySource.class);
        Set beanEntrySet = beansWithAnnotation.entrySet();
        if (beanEntrySet.isEmpty()) {
            log.warn("Not found @BladePropertySource on spring bean class.");
            return;
        }
        ArrayList<PropertyFile> propertyFileList = new ArrayList<PropertyFile>();
        for (Map.Entry entry : beanEntrySet) {
            Class beanClass = ClassUtils.getUserClass(entry.getValue());
            BladePropertySource propertySource = (BladePropertySource)AnnotationUtils.getAnnotation((AnnotatedElement)beanClass, BladePropertySource.class);
            if (propertySource == null) continue;
            int order = propertySource.order();
            int loadActiveProfile = propertySource.loadActiveProfile();
            String location = propertySource.value();
            propertyFileList.add(new PropertyFile(order, location, loadActiveProfile != 0));
        }
        HashMap<String, PropertySourceLoader> loaderMap = new HashMap<String, PropertySourceLoader>(16);
        for (PropertySourceLoader loader : this.propertySourceLoaders) {
            String[] loaderExtensions;
            for (String extension : loaderExtensions = loader.getFileExtensions()) {
                loaderMap.put(extension, loader);
            }
        }
        List sortedPropertyList = propertyFileList.stream().distinct().sorted().collect(Collectors.toList());
        ConfigurableEnvironment environment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        MutablePropertySources propertySources = environment.getPropertySources();
        String[] activeProfiles = environment.getActiveProfiles();
        ArrayList<PropertySource> propertySourceList = new ArrayList<PropertySource>();
        for (String profile : activeProfiles) {
            for (PropertyFile propertyFile : sortedPropertyList) {
                if (!propertyFile.loadActiveProfile) continue;
                String extension = propertyFile.getExtension();
                PropertySourceLoader loader = (PropertySourceLoader)loaderMap.get(extension);
                if (loader == null) {
                    throw new IllegalArgumentException("Can't find PropertySourceLoader for PropertySource extension:" + extension);
                }
                String location = propertyFile.getLocation();
                String filePath = StringUtils.stripFilenameExtension((String)location);
                String profiledLocation = filePath + "-" + profile + "." + extension;
                Resource resource = this.resourceLoader.getResource(profiledLocation);
                BladePropertySourcePostProcessor.loadPropertySource(profiledLocation, resource, loader, propertySourceList);
            }
        }
        for (PropertyFile propertyFile : sortedPropertyList) {
            String extension = propertyFile.getExtension();
            PropertySourceLoader loader = (PropertySourceLoader)loaderMap.get(extension);
            String location = propertyFile.getLocation();
            Resource resource = this.resourceLoader.getResource(location);
            BladePropertySourcePostProcessor.loadPropertySource(location, resource, loader, propertySourceList);
        }
        for (PropertySource propertySource : propertySourceList) {
            propertySources.addLast(propertySource);
        }
    }

    private static void loadPropertySource(String location, Resource resource, PropertySourceLoader loader, List<PropertySource> sourceList) {
        if (resource.exists()) {
            String name = "bladePropertySource: [" + location + "]";
            try {
                sourceList.addAll(loader.load(name, resource));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        log.info("BladePropertySourcePostProcessor init.");
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static class PropertyFile
    implements Comparable<PropertyFile> {
        private final int order;
        private final String location;
        private final String extension;
        private final boolean loadActiveProfile;

        PropertyFile(int order, String location, boolean loadActiveProfile) {
            this.order = order;
            this.location = location;
            this.loadActiveProfile = loadActiveProfile;
            this.extension = Objects.requireNonNull(StringUtils.getFilenameExtension((String)location));
        }

        @Override
        public int compareTo(PropertyFile other) {
            return Integer.compare(this.order, other.order);
        }

        public int getOrder() {
            return this.order;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean isLoadActiveProfile() {
            return this.loadActiveProfile;
        }

        public String toString() {
            return "BladePropertySourcePostProcessor.PropertyFile(order=" + this.getOrder() + ", location=" + this.getLocation() + ", extension=" + this.getExtension() + ", loadActiveProfile=" + this.isLoadActiveProfile() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyFile)) {
                return false;
            }
            PropertyFile other = (PropertyFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (this.isLoadActiveProfile() != other.isLoadActiveProfile()) {
                return false;
            }
            String this$location = this.getLocation();
            String other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$extension = this.getExtension();
            String other$extension = other.getExtension();
            return !(this$extension == null ? other$extension != null : !this$extension.equals(other$extension));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            result = result * 59 + (this.isLoadActiveProfile() ? 79 : 97);
            String $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $extension = this.getExtension();
            result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
            return result;
        }
    }
}

