/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.launch;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

@AutoConfiguration
public class StartEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartEventListener.class);

    @Async
    @Order
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        Environment environment = event.getApplicationContext().getEnvironment();
        String appName = environment.getProperty("spring.application.name").toUpperCase();
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        log.info("---[{}]---\u542f\u52a8\u5b8c\u6210\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u7aef\u53e3:[{}]\uff0c\u73af\u5883\u53d8\u91cf:[{}]---", new Object[]{appName, localPort, profile});
    }
}

