/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.launch.server;

import lombok.Generated;
import org.springblade.core.launch.utils.INetUtil;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;

@AutoConfiguration
public class ServerInfo
implements SmartInitializingSingleton {
    private final ServerProperties serverProperties;
    private String hostName;
    private String ip;
    private Integer port;
    private String ipWithPort;

    @Autowired(required=false)
    public ServerInfo(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void afterSingletonsInstantiated() {
        this.hostName = INetUtil.getHostName();
        this.ip = INetUtil.getHostIp();
        this.port = this.serverProperties.getPort();
        this.ipWithPort = String.format("%s:%d", this.ip, this.port);
    }

    @Generated
    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getIpWithPort() {
        return this.ipWithPort;
    }
}

