/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mp.support;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Map;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;

public class SqlKeyword {
    private static final String SQL_REGEX = "'|%|--|insert|delete|select|count|group|union|drop|truncate|alter|grant|execute|exec|xp_cmdshell|call|declare|sql";
    private static final String EQUAL = "_equal";
    private static final String NOT_EQUAL = "_notequal";
    private static final String LIKE = "_like";
    private static final String NOT_LIKE = "_notlike";
    private static final String GT = "_gt";
    private static final String LT = "_lt";
    private static final String DATE_GT = "_dategt";
    private static final String DATE_EQUAL = "_dateequal";
    private static final String DATE_LT = "_datelt";
    private static final String IS_NULL = "_null";
    private static final String NOT_NULL = "_notnull";
    private static final String IGNORE = "_ignore";

    public static void buildCondition(Map<String, Object> query, QueryWrapper<?> qw) {
        if (Func.isEmpty(query)) {
            return;
        }
        query.forEach((k, v) -> {
            if (Func.hasEmpty((Object[])new Object[]{k, v}) || k.endsWith(IGNORE)) {
                return;
            }
            if (k.endsWith(EQUAL)) {
                qw.eq((Object)SqlKeyword.getColumn(k, EQUAL), v);
            } else if (k.endsWith(NOT_EQUAL)) {
                qw.ne((Object)SqlKeyword.getColumn(k, NOT_EQUAL), v);
            } else if (k.endsWith(NOT_LIKE)) {
                qw.notLike((Object)SqlKeyword.getColumn(k, NOT_LIKE), v);
            } else if (k.endsWith(GT)) {
                qw.gt((Object)SqlKeyword.getColumn(k, GT), v);
            } else if (k.endsWith(LT)) {
                qw.lt((Object)SqlKeyword.getColumn(k, LT), v);
            } else if (k.endsWith(DATE_GT)) {
                qw.gt((Object)SqlKeyword.getColumn(k, DATE_GT), v);
            } else if (k.endsWith(DATE_EQUAL)) {
                qw.eq((Object)SqlKeyword.getColumn(k, DATE_EQUAL), v);
            } else if (k.endsWith(DATE_LT)) {
                qw.lt((Object)SqlKeyword.getColumn(k, DATE_LT), v);
            } else if (k.endsWith(IS_NULL)) {
                qw.isNull((Object)SqlKeyword.getColumn(k, IS_NULL));
            } else if (k.endsWith(NOT_NULL)) {
                qw.isNotNull((Object)SqlKeyword.getColumn(k, NOT_NULL));
            } else {
                qw.like((Object)SqlKeyword.getColumn(k, LIKE), v);
            }
        });
    }

    private static String getColumn(String column, String keyword) {
        return StringUtil.humpToUnderline((String)StringUtil.removeSuffix((CharSequence)column, (CharSequence)keyword));
    }

    public static String filter(String param) {
        if (param == null) {
            return null;
        }
        return param.replaceAll("(?i)'|%|--|insert|delete|select|count|group|union|drop|truncate|alter|grant|execute|exec|xp_cmdshell|call|declare|sql", "");
    }
}

