/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.api.IResultCode;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.api.ResultCode;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class ClientInterceptor
implements AsyncHandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientInterceptor.class);
    private final String clientId;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        BladeUser user = SecureUtil.getUser();
        if (user != null && StringUtil.equals((CharSequence)this.clientId, (CharSequence)SecureUtil.getClientIdFromHeader()) && StringUtil.equals((CharSequence)this.clientId, (CharSequence)user.getClientId())) {
            return true;
        }
        log.warn("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u63a5\u53e3\uff1a{}\uff0c\u8bf7\u6c42IP\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{request.getRequestURI(), WebUtil.getIP((HttpServletRequest)request), JsonUtil.toJson((Object)request.getParameterMap())});
        R result = R.fail((IResultCode)ResultCode.UN_AUTHORIZED);
        response.setHeader("Content-type", "application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try {
            response.getWriter().write(Objects.requireNonNull(JsonUtil.toJson((Object)result)));
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
        }
        return false;
    }

    @Generated
    public ClientInterceptor(String clientId) {
        this.clientId = clientId;
    }
}

