/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.test;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springblade.core.launch.BladeApplication;
import org.springblade.core.launch.service.LauncherService;
import org.springblade.core.test.BladeBootTest;
import org.springblade.core.test.BladeBootTestException;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class BladeSpringExtension
extends SpringExtension {
    public void beforeAll(@NonNull ExtensionContext context) throws Exception {
        super.beforeAll(context);
        this.setUpTestClass(context);
    }

    private void setUpTestClass(ExtensionContext context) {
        Class clazz = context.getRequiredTestClass();
        BladeBootTest bladeBootTest = (BladeBootTest)AnnotationUtils.getAnnotation((AnnotatedElement)clazz, BladeBootTest.class);
        if (bladeBootTest == null) {
            throw new BladeBootTestException(String.format("%s must be @BladeBootTest .", clazz));
        }
        String appName = bladeBootTest.appName();
        String profile = bladeBootTest.profile();
        boolean isLocalDev = BladeApplication.isLocalDev();
        Properties props = System.getProperties();
        props.setProperty("blade.env", profile);
        props.setProperty("blade.name", appName);
        props.setProperty("blade.is-local", String.valueOf(isLocalDev));
        props.setProperty("blade.dev-mode", profile.equals("prod") ? "false" : "true");
        props.setProperty("blade.service.version", "4.0.0");
        props.setProperty("spring.application.name", appName);
        props.setProperty("spring.profiles.active", profile);
        props.setProperty("info.version", "4.0.0");
        props.setProperty("info.desc", appName);
        props.setProperty("spring.cloud.nacos.discovery.server-addr", "127.0.0.1:8848");
        props.setProperty("spring.cloud.nacos.config.server-addr", "127.0.0.1:8848");
        props.setProperty("spring.cloud.nacos.config.prefix", "blade");
        props.setProperty("spring.cloud.nacos.config.file-extension", "yaml");
        props.setProperty("spring.cloud.sentinel.transport.dashboard", "127.0.0.1:8858");
        props.setProperty("spring.main.allow-bean-definition-overriding", "true");
        if (bladeBootTest.enableLoader()) {
            ArrayList launcherList = new ArrayList();
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{clazz});
            ServiceLoader.load(LauncherService.class).forEach(launcherList::add);
            launcherList.stream().sorted(Comparator.comparing(LauncherService::getOrder)).toList().forEach(launcherService -> launcherService.launcher(builder, appName, profile));
        }
        System.err.printf("---[junit.test]:[%s]---\u542f\u52a8\u4e2d\uff0c\u8bfb\u53d6\u5230\u7684\u73af\u5883\u53d8\u91cf:[%s]%n", appName, profile);
    }
}

