/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@ControllerEndpoint(id="swagger-ui")
public class SwaggerWelcomeActuator
extends SwaggerWelcomeCommon {
    private static final String SWAGGER_CONFIG_ACTUATOR_URL = "/swagger-config";
    private final WebEndpointProperties webEndpointProperties;
    private final ManagementServerProperties managementServerProperties;

    public SwaggerWelcomeActuator(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, WebEndpointProperties webEndpointProperties, ManagementServerProperties managementServerProperties) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.webEndpointProperties = webEndpointProperties;
        this.managementServerProperties = managementServerProperties;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        return super.redirectToUi(request, response);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        return super.getSwaggerUiConfig(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.webEndpointProperties.getBasePath());
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            UriComponentsBuilder oauthPrefix = uriComponentsBuilder.path(this.managementServerProperties.getBasePath() + this.swaggerUiConfigParameters.getUiRootPath()).path(this.webJarsPrefixUrl);
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(oauthPrefix.path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected String buildApiDocUrl() {
        return this.buildUrl(this.contextPath + this.webEndpointProperties.getBasePath(), "openapi");
    }

    protected String buildUrlWithContextPath(String swaggerUiUrl) {
        return this.buildUrl(this.contextPath + this.webEndpointProperties.getBasePath(), swaggerUiUrl);
    }

    protected String buildSwaggerConfigUrl() {
        return this.contextPath + this.webEndpointProperties.getBasePath() + "/swagger-ui/swagger-config";
    }
}

