/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import com.couchbase.client.core.message.internal.DiagnosticsReport;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.cluster.ClusterInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CouchbaseHealthIndicator
extends AbstractHealthIndicator {
    private final HealthCheck healthCheck;

    @Deprecated
    public CouchbaseHealthIndicator(CouchbaseOperations couchbaseOperations, Duration timeout) {
        super("Couchbase health check failed");
        Assert.notNull((Object)couchbaseOperations, (String)"CouchbaseOperations must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        this.healthCheck = new OperationsHealthCheck(couchbaseOperations, timeout.toMillis());
    }

    @Deprecated
    public CouchbaseHealthIndicator(CouchbaseOperations couchbaseOperations) {
        this(couchbaseOperations, Duration.ofSeconds(1L));
    }

    public CouchbaseHealthIndicator(Cluster cluster) {
        super("Couchbase health check failed");
        Assert.notNull((Object)cluster, (String)"Cluster must not be null");
        this.healthCheck = new ClusterHealthCheck(cluster);
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        this.healthCheck.checkHealth(builder);
    }

    private static class ClusterHealthCheck
    implements HealthCheck {
        private final Cluster cluster;

        ClusterHealthCheck(Cluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public void checkHealth(Health.Builder builder) throws Exception {
            DiagnosticsReport diagnostics = this.cluster.diagnostics();
            builder = this.isCouchbaseUp(diagnostics) ? builder.up() : builder.down();
            builder.withDetail("sdk", diagnostics.sdk());
            builder.withDetail("endpoints", diagnostics.endpoints().stream().map(this::describe).collect(Collectors.toList()));
        }

        private boolean isCouchbaseUp(DiagnosticsReport diagnostics) {
            for (EndpointHealth health : diagnostics.endpoints()) {
                LifecycleState state = health.state();
                if (state == LifecycleState.CONNECTED || state == LifecycleState.IDLE) continue;
                return false;
            }
            return true;
        }

        private Map<String, Object> describe(EndpointHealth endpointHealth) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", endpointHealth.id());
            map.put("lastActivity", endpointHealth.lastActivity());
            map.put("local", endpointHealth.local().toString());
            map.put("remote", endpointHealth.remote().toString());
            map.put("state", endpointHealth.state());
            map.put("type", endpointHealth.type());
            return map;
        }
    }

    private static final class OperationsHealthCheck
    implements HealthCheck {
        private final CouchbaseOperations operations;
        private final long timeout;

        OperationsHealthCheck(CouchbaseOperations operations, long timeout) {
            this.operations = operations;
            this.timeout = timeout;
        }

        @Override
        public void checkHealth(Health.Builder builder) throws Exception {
            ClusterInfo cluster = this.operations.getCouchbaseClusterInfo();
            BucketInfo bucket = this.getBucketInfo();
            String versions = StringUtils.collectionToCommaDelimitedString((Collection)cluster.getAllVersions());
            String nodes = StringUtils.collectionToCommaDelimitedString((Collection)bucket.nodeList());
            builder.up().withDetail("versions", versions).withDetail("nodes", nodes);
        }

        private BucketInfo getBucketInfo() throws Exception {
            try {
                return this.operations.getCouchbaseBucket().bucketManager().info(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof TimeoutException) {
                    throw (TimeoutException)ex.getCause();
                }
                throw ex;
            }
        }
    }

    private static interface HealthCheck {
        public void checkHealth(Health.Builder var1) throws Exception;
    }
}

