/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.endpoint.SanitizableData;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;

public class Sanitizer {
    private final List<SanitizingFunction> sanitizingFunctions = new ArrayList<SanitizingFunction>();

    public Sanitizer() {
        this(Collections.emptyList());
    }

    public Sanitizer(Iterable<SanitizingFunction> sanitizingFunctions) {
        sanitizingFunctions.forEach(this.sanitizingFunctions::add);
    }

    public Object sanitize(SanitizableData data, boolean showUnsanitized) {
        Object value = data.getValue();
        if (value == null) {
            return null;
        }
        if (!showUnsanitized) {
            return "******";
        }
        for (SanitizingFunction sanitizingFunction : this.sanitizingFunctions) {
            data = sanitizingFunction.applyUnlessFiltered(data);
            Object sanitizedValue = data.getValue();
            if (value.equals(sanitizedValue)) continue;
            return sanitizedValue;
        }
        return value;
    }
}

