/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class JsonStream {
    private final ObjectMapper objectMapper;

    public JsonStream(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void get(InputStream content, Consumer<ObjectNode> consumer) throws IOException {
        this.get(content, ObjectNode.class, consumer);
    }

    public <T> void get(InputStream content, Class<T> type, Consumer<T> consumer) throws IOException {
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        try (JsonParser parser = jsonFactory.createParser(content);){
            while (!parser.isClosed()) {
                T node;
                JsonToken token = parser.nextToken();
                if (token == null || token == JsonToken.END_OBJECT || (node = this.read(parser, type)) == null) continue;
                consumer.accept(node);
            }
        }
    }

    private <T> T read(JsonParser parser, Class<T> type) throws IOException {
        if (ObjectNode.class.isAssignableFrom(type)) {
            ObjectNode node = (ObjectNode)this.objectMapper.readTree(parser);
            if (node == null || node.isMissingNode() || node.isEmpty()) {
                return null;
            }
            return (T)node;
        }
        return (T)this.objectMapper.readValue(parser, type);
    }
}

