/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.util.Assert;

public class CacheInfo {
    private Cache cache;

    public CacheInfo() {
    }

    private CacheInfo(Cache cache) {
        this.cache = cache;
    }

    public void setVolume(VolumeCacheInfo info) {
        Assert.state((this.cache == null ? 1 : 0) != 0, (String)"Each image building cache can be configured only once");
        this.cache = Cache.volume((String)info.getName());
    }

    public void setBind(BindCacheInfo info) {
        Assert.state((this.cache == null ? 1 : 0) != 0, (String)"Each image building cache can be configured only once");
        this.cache = Cache.bind((String)info.getSource());
    }

    Cache asCache() {
        return this.cache;
    }

    static CacheInfo fromVolume(VolumeCacheInfo cacheInfo) {
        return new CacheInfo(Cache.volume((String)cacheInfo.getName()));
    }

    static CacheInfo fromBind(BindCacheInfo cacheInfo) {
        return new CacheInfo(Cache.bind((String)cacheInfo.getSource()));
    }

    public static class VolumeCacheInfo {
        private String name;

        public VolumeCacheInfo() {
        }

        VolumeCacheInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }
    }

    public static class BindCacheInfo {
        private String source;

        public BindCacheInfo() {
        }

        BindCacheInfo(String name) {
            this.source = name;
        }

        public String getSource() {
            return this.source;
        }

        void setSource(String source) {
            this.source = source;
        }
    }
}

