/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class ConsulAutoServiceRegistrationListener
implements SmartApplicationListener {
    private final ConsulAutoServiceRegistration autoServiceRegistration;

    public ConsulAutoServiceRegistrationListener(ConsulAutoServiceRegistration autoServiceRegistration) {
        this.autoServiceRegistration = autoServiceRegistration;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return WebServerInitializedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof WebServerInitializedEvent) {
            WebServerInitializedEvent event = (WebServerInitializedEvent)applicationEvent;
            WebServerApplicationContext context = event.getApplicationContext();
            if (context instanceof ConfigurableWebServerApplicationContext && "management".equals(((ConfigurableWebServerApplicationContext)context).getServerNamespace())) {
                return;
            }
            this.autoServiceRegistration.setPortIfNeeded(event.getWebServer().getPort());
            this.autoServiceRegistration.start();
        }
    }

    public int getOrder() {
        return 0;
    }
}

