/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.bootstrap.TextEncryptorConfigBootstrapper;
import org.springframework.cloud.bootstrap.encrypt.AbstractEnvironmentDecrypt;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.ClassUtils;

public class DecryptEnvironmentPostProcessor
extends AbstractEnvironmentDecrypt
implements EnvironmentPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (PropertyUtils.bootstrapEnabled((Environment)environment) || PropertyUtils.useLegacyProcessing((Environment)environment)) {
            return;
        }
        MutablePropertySources propertySources = environment.getPropertySources();
        environment.getPropertySources().remove("decrypted");
        TextEncryptor encryptor = this.getTextEncryptor(environment);
        Map<String, Object> map = this.decrypt(encryptor, (PropertySources)propertySources);
        if (!map.isEmpty()) {
            propertySources.addFirst((PropertySource)new SystemEnvironmentPropertySource("decrypted", map));
        }
    }

    protected TextEncryptor getTextEncryptor(ConfigurableEnvironment environment) {
        Binder binder = Binder.get((Environment)environment);
        KeyProperties keyProperties = (KeyProperties)binder.bind("encrypt", KeyProperties.class).orElseGet(KeyProperties::new);
        if (TextEncryptorConfigBootstrapper.keysConfigured(keyProperties)) {
            if (ClassUtils.isPresent((String)"org.springframework.security.rsa.crypto.RsaSecretEncryptor", null)) {
                RsaProperties rsaProperties = (RsaProperties)binder.bind("encrypt.rsa", RsaProperties.class).orElseGet(RsaProperties::new);
                return TextEncryptorConfigBootstrapper.rsaTextEncryptor(keyProperties, rsaProperties);
            }
            return new EncryptorFactory(keyProperties.getSalt()).create(keyProperties.getKey());
        }
        return new TextEncryptorConfigBootstrapper.FailsafeTextEncryptor();
    }
}

