/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.ribbon.KubernetesEndpointsServerList;
import org.springframework.cloud.kubernetes.ribbon.KubernetesRibbonMode;
import org.springframework.cloud.kubernetes.ribbon.KubernetesRibbonProperties;
import org.springframework.cloud.kubernetes.ribbon.KubernetesServerList;
import org.springframework.cloud.kubernetes.ribbon.KubernetesServicesServerList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={KubernetesRibbonProperties.class})
public class KubernetesRibbonClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(KubernetesClient client, IClientConfig config, KubernetesRibbonProperties properties) {
        KubernetesServerList serverList = properties.getMode() == KubernetesRibbonMode.SERVICE ? new KubernetesServicesServerList(client, properties) : new KubernetesEndpointsServerList(client, properties);
        serverList.initWithNiwsConfig(config);
        return serverList;
    }
}

