/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.index.VersionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.annotations.Parent;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.join.JoinField;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleElasticsearchPersistentEntity<T>
extends BasicPersistentEntity<T, ElasticsearchPersistentProperty>
implements ElasticsearchPersistentEntity<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchPersistentEntity.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    @Nullable
    private String indexName;
    private boolean useServerConfiguration;
    private short shards;
    private short replicas;
    @Nullable
    private String refreshInterval;
    @Nullable
    private String indexStoreType;
    @Deprecated
    @Nullable
    private String parentType;
    @Deprecated
    @Nullable
    private ElasticsearchPersistentProperty parentIdProperty;
    @Nullable
    private ElasticsearchPersistentProperty scoreProperty;
    @Nullable
    private ElasticsearchPersistentProperty seqNoPrimaryTermProperty;
    @Nullable
    private ElasticsearchPersistentProperty joinFieldProperty;
    @Nullable
    private String settingPath;
    @Nullable
    private VersionType versionType;
    private boolean createIndexAndMapping;
    private final Map<String, ElasticsearchPersistentProperty> fieldNamePropertyCache = new ConcurrentHashMap<String, ElasticsearchPersistentProperty>();
    private final ConcurrentHashMap<String, Expression> indexNameExpressions = new ConcurrentHashMap();

    public SimpleElasticsearchPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        Class clazz = typeInformation.getType();
        if (clazz.isAnnotationPresent(org.springframework.data.elasticsearch.annotations.Document.class)) {
            org.springframework.data.elasticsearch.annotations.Document document = clazz.getAnnotation(org.springframework.data.elasticsearch.annotations.Document.class);
            Assert.hasText((String)document.indexName(), (String)" Unknown indexName. Make sure the indexName is defined. e.g @Document(indexName=\"foo\")");
            this.indexName = document.indexName();
            this.useServerConfiguration = document.useServerConfiguration();
            this.shards = document.shards();
            this.replicas = document.replicas();
            this.refreshInterval = document.refreshInterval();
            this.indexStoreType = document.indexStoreType();
            this.versionType = document.versionType();
            this.createIndexAndMapping = document.createIndex();
        }
        if (clazz.isAnnotationPresent(Setting.class)) {
            this.settingPath = typeInformation.getType().getAnnotation(Setting.class).settingPath();
        }
    }

    private String getIndexName() {
        return this.indexName != null ? this.indexName : this.getTypeInformation().getType().getSimpleName();
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.resolve(IndexCoordinates.of(this.getIndexName()));
    }

    @Override
    @Nullable
    public String getIndexStoreType() {
        return this.indexStoreType;
    }

    @Override
    public short getShards() {
        return this.shards;
    }

    @Override
    public short getReplicas() {
        return this.replicas;
    }

    @Override
    public boolean isUseServerConfiguration() {
        return this.useServerConfiguration;
    }

    @Override
    @Nullable
    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    @Nullable
    @Deprecated
    public String getParentType() {
        return this.parentType;
    }

    @Override
    @Nullable
    @Deprecated
    public ElasticsearchPersistentProperty getParentIdProperty() {
        return this.parentIdProperty;
    }

    @Override
    @Nullable
    public VersionType getVersionType() {
        return this.versionType;
    }

    @Override
    public String settingPath() {
        return this.settingPath;
    }

    @Override
    public boolean isCreateIndexAndMapping() {
        return this.createIndexAndMapping;
    }

    @Override
    public boolean hasScoreProperty() {
        return this.scoreProperty != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getScoreProperty() {
        return this.scoreProperty;
    }

    public void addPersistentProperty(ElasticsearchPersistentProperty property) {
        Class<?> actualType;
        super.addPersistentProperty((PersistentProperty)property);
        if (property.isParentProperty()) {
            ElasticsearchPersistentProperty parentProperty = this.parentIdProperty;
            if (parentProperty != null) {
                throw new MappingException(String.format("Attempt to add parent property %s but already have property %s registered as parent property. Check your mapping configuration!", property.getField(), parentProperty.getField()));
            }
            Parent parentAnnotation = (Parent)property.findAnnotation(Parent.class);
            this.parentIdProperty = property;
            this.parentType = parentAnnotation.type();
        }
        if (property.isScoreProperty()) {
            ElasticsearchPersistentProperty scoreProperty = this.scoreProperty;
            if (scoreProperty != null) {
                throw new MappingException(String.format("Attempt to add score property %s but already have property %s registered as score property. Check your mapping configuration!", property.getField(), scoreProperty.getField()));
            }
            this.scoreProperty = property;
        }
        if (property.isSeqNoPrimaryTermProperty()) {
            ElasticsearchPersistentProperty seqNoPrimaryTermProperty = this.seqNoPrimaryTermProperty;
            if (seqNoPrimaryTermProperty != null) {
                throw new MappingException(String.format("Attempt to add SeqNoPrimaryTerm property %s but already have property %s registered as SeqNoPrimaryTerm property. Check your entity configuration!", property.getField(), seqNoPrimaryTermProperty.getField()));
            }
            this.seqNoPrimaryTermProperty = property;
            if (this.hasVersionProperty()) {
                this.warnAboutBothSeqNoPrimaryTermAndVersionProperties();
            }
        }
        if (property.isVersionProperty() && this.hasSeqNoPrimaryTermProperty()) {
            this.warnAboutBothSeqNoPrimaryTermAndVersionProperties();
        }
        if ((actualType = property.getActualTypeOrNull()) == JoinField.class) {
            ElasticsearchPersistentProperty joinProperty = this.joinFieldProperty;
            if (joinProperty != null) {
                throw new MappingException(String.format("Attempt to add Join property %s but already have property %s registered as Join property. Check your entity configuration!", property.getField(), joinProperty.getField()));
            }
            this.joinFieldProperty = property;
        }
    }

    private void warnAboutBothSeqNoPrimaryTermAndVersionProperties() {
        LOGGER.warn("Both SeqNoPrimaryTerm and @Version properties are defined on {}. Version will not be sent in index requests when seq_no is sent!", (Object)this.getType());
    }

    public void setPersistentPropertyAccessorFactory(PersistentPropertyAccessorFactory factory) {
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getPersistentPropertyWithFieldName(String fieldName) {
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null");
        return this.fieldNamePropertyCache.computeIfAbsent(fieldName, key -> {
            AtomicReference propertyRef = new AtomicReference();
            this.doWithProperties(property -> {
                if (key.equals(property.getFieldName())) {
                    propertyRef.set(property);
                }
            });
            return (ElasticsearchPersistentProperty)propertyRef.get();
        });
    }

    @Override
    public boolean hasSeqNoPrimaryTermProperty() {
        return this.seqNoPrimaryTermProperty != null;
    }

    @Override
    public boolean hasJoinFieldProperty() {
        return this.joinFieldProperty != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getSeqNoPrimaryTermProperty() {
        return this.seqNoPrimaryTermProperty;
    }

    @Override
    public ElasticsearchPersistentProperty getJoinFieldProperty() {
        return this.joinFieldProperty;
    }

    private IndexCoordinates resolve(IndexCoordinates indexCoordinates) {
        EvaluationContext context = this.getEvaluationContext(null);
        String[] indexNames = indexCoordinates.getIndexNames();
        String[] resolvedNames = new String[indexNames.length];
        for (int i = 0; i < indexNames.length; ++i) {
            String indexName = indexNames[i];
            resolvedNames[i] = this.resolve(context, indexName);
        }
        return IndexCoordinates.of(resolvedNames);
    }

    private String resolve(EvaluationContext context, String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Expression expression = this.indexNameExpressions.computeIfAbsent(name, s -> {
            Expression expr = PARSER.parseExpression(name, ParserContext.TEMPLATE_EXPRESSION);
            return expr instanceof LiteralExpression ? null : expr;
        });
        String resolvedName = expression != null ? (String)expression.getValue(context, String.class) : null;
        return resolvedName != null ? resolvedName : name;
    }

    @Override
    public Document getDefaultSettings() {
        if (this.isUseServerConfiguration()) {
            return Document.create();
        }
        Map map = new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(this.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(this.getReplicas())).put((Object)"index.refresh_interval", (Object)this.getRefreshInterval()).put((Object)"index.store.type", (Object)this.getIndexStoreType()).map();
        return Document.from(map);
    }
}

