/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.reflect.Constructor;
import java.sql.JDBCType;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class StringBasedJdbcQuery
extends AbstractJdbcQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final JdbcQueryMethod queryMethod;
    private final JdbcConverter converter;
    private final AbstractJdbcQuery.RowMapperFactory rowMapperFactory;
    private BeanFactory beanFactory;

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper, JdbcConverter converter) {
        this(queryMethod, operations, (Class<?> result) -> defaultRowMapper, converter);
    }

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, AbstractJdbcQuery.RowMapperFactory rowMapperFactory, JdbcConverter converter) {
        super(queryMethod, operations);
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        this.queryMethod = queryMethod;
        this.converter = converter;
        this.rowMapperFactory = rowMapperFactory;
        if (queryMethod.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
        if (queryMethod.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries. Offending method: " + (Object)((Object)queryMethod));
        }
    }

    public Object execute(Object[] objects) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), objects);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        JdbcQueryExecution.ResultProcessingConverter converter = new JdbcQueryExecution.ResultProcessingConverter(processor, this.converter.getMappingContext(), this.converter.getEntityInstantiators());
        RowMapper<Object> rowMapper = this.determineRowMapper(this.rowMapperFactory.create(this.resolveTypeToRead(processor)), converter, accessor.findDynamicProjection() != null);
        JdbcQueryExecution<?> queryExecution = this.getQueryExecution(this.queryMethod, this.determineResultSetExtractor(rowMapper), rowMapper);
        return queryExecution.execute(this.determineQuery(), (SqlParameterSource)this.bindParameters((RelationalParameterAccessor)accessor));
    }

    @Override
    public JdbcQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private MapSqlParameterSource bindParameters(RelationalParameterAccessor accessor) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        Parameters bindableParameters = accessor.getBindableParameters();
        for (Parameter bindableParameter : bindableParameters) {
            this.convertAndAddParameter(parameters, bindableParameter, accessor.getBindableValue(bindableParameter.getIndex()));
        }
        return parameters;
    }

    private void convertAndAddParameter(MapSqlParameterSource parameters, Parameter p, Object value) {
        String parameterName = (String)p.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
        Class parameterType = ((RelationalParameters.RelationalParameter)this.queryMethod.getParameters().getParameter(p.getIndex())).getType();
        Class<?> conversionTargetType = JdbcColumnTypes.INSTANCE.resolvePrimitiveType(parameterType);
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, conversionTargetType, JdbcUtil.sqlTypeFor(conversionTargetType));
        JDBCType jdbcType = jdbcValue.getJdbcType();
        if (jdbcType == null) {
            parameters.addValue(parameterName, jdbcValue.getValue());
        } else {
            parameters.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
        }
    }

    private String determineQuery() {
        String query = this.queryMethod.getDeclaredQuery();
        if (ObjectUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.queryMethod.getName()));
        }
        return query;
    }

    @Nullable
    ResultSetExtractor<Object> determineResultSetExtractor(@Nullable RowMapper<Object> rowMapper) {
        String resultSetExtractorRef = this.queryMethod.getResultSetExtractorRef();
        if (!StringUtils.isEmpty((Object)resultSetExtractorRef)) {
            Assert.notNull((Object)this.beanFactory, (String)"When a ResultSetExtractorRef is specified the BeanFactory must not be null");
            return (ResultSetExtractor)this.beanFactory.getBean(resultSetExtractorRef);
        }
        Class<? extends ResultSetExtractor> resultSetExtractorClass = this.queryMethod.getResultSetExtractorClass();
        if (StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
            return null;
        }
        Constructor constructor = ClassUtils.getConstructorIfAvailable(resultSetExtractorClass, (Class[])new Class[]{RowMapper.class});
        if (constructor != null) {
            return (ResultSetExtractor)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{rowMapper});
        }
        return (ResultSetExtractor)BeanUtils.instantiateClass(resultSetExtractorClass);
    }

    @Nullable
    RowMapper<Object> determineRowMapper(@Nullable RowMapper<?> defaultMapper, Converter<Object, Object> resultProcessingConverter, boolean hasDynamicProjection) {
        RowMapper<Object> rowMapperToUse = this.determineRowMapper(defaultMapper);
        if ((hasDynamicProjection || rowMapperToUse == defaultMapper) && rowMapperToUse != null) {
            return new AbstractJdbcQuery.ConvertingRowMapper<Object>(rowMapperToUse, resultProcessingConverter);
        }
        return rowMapperToUse;
    }

    @Nullable
    RowMapper<Object> determineRowMapper(@Nullable RowMapper<?> defaultMapper) {
        String rowMapperRef = this.queryMethod.getRowMapperRef();
        if (!StringUtils.isEmpty((Object)rowMapperRef)) {
            Assert.notNull((Object)this.beanFactory, (String)"When a RowMapperRef is specified the BeanFactory must not be null");
            return (RowMapper)this.beanFactory.getBean(rowMapperRef);
        }
        Class<? extends RowMapper> rowMapperClass = this.queryMethod.getRowMapperClass();
        if (StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
            return defaultMapper;
        }
        return (RowMapper)BeanUtils.instantiateClass(rowMapperClass);
    }

    private static boolean isUnconfigured(@Nullable Class<?> configuredClass, Class<?> defaultClass) {
        return configuredClass == null || configuredClass == defaultClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

