/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionContext;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

final class Neo4jTransactionHolder
extends ResourceHolderSupport {
    private final Neo4jTransactionContext context;
    private final Session session;
    private final Transaction transaction;

    Neo4jTransactionHolder(Neo4jTransactionContext context, Session session, Transaction transaction) {
        this.context = context;
        this.session = session;
        this.transaction = transaction;
    }

    @Nullable
    Transaction getTransaction(String inDatabase) {
        return Neo4jTransactionUtils.namesMapToTheSameDatabase(this.context.getDatabaseName(), inDatabase) ? this.transaction : null;
    }

    @Nullable
    Bookmark commit() {
        Assert.state((boolean)this.hasActiveTransaction(), (String)"Transaction must be open, but has already been closed.");
        Assert.state((!this.isRollbackOnly() ? 1 : 0) != 0, (String)"Resource must not be marked as rollback only.");
        this.transaction.commit();
        this.transaction.close();
        return this.session.lastBookmark();
    }

    void rollback() {
        Assert.state((boolean)this.hasActiveTransaction(), (String)"Transaction must be open, but has already been closed.");
        this.transaction.rollback();
        this.transaction.close();
    }

    void close() {
        Assert.state((boolean)this.hasActiveSession(), (String)"Session must be open, but has already been closed.");
        if (this.hasActiveTransaction()) {
            this.transaction.close();
        }
        this.session.close();
    }

    public void setRollbackOnly() {
        super.setRollbackOnly();
        this.transaction.rollback();
    }

    public void resetRollbackOnly() {
        throw new UnsupportedOperationException();
    }

    boolean hasActiveSession() {
        return this.session.isOpen();
    }

    boolean hasActiveTransaction() {
        return this.transaction.isOpen();
    }

    String getDatabaseName() {
        return this.context.getDatabaseName();
    }

    Collection<Bookmark> getBookmarks() {
        return this.context.getBookmarks();
    }
}

