/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.mapping;

import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.lang.Nullable;

public interface RedisPersistentEntity<T>
extends KeyValuePersistentEntity<T, RedisPersistentProperty> {
    public TimeToLiveAccessor getTimeToLiveAccessor();

    @Deprecated(forRemoval=true)
    default public boolean hasExplictTimeToLiveProperty() {
        return this.hasExplicitTimeToLiveProperty();
    }

    default public boolean hasExplicitTimeToLiveProperty() {
        return this.getExplicitTimeToLiveProperty() != null;
    }

    @Nullable
    public RedisPersistentProperty getExplicitTimeToLiveProperty();

    default public boolean isExpiring() {
        return this.getTimeToLiveAccessor().isExpiringEntity(this.getType());
    }
}

