/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.beans.Field;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.solr.core.mapping.ChildDocument;
import org.springframework.data.solr.core.mapping.Dynamic;
import org.springframework.data.solr.core.mapping.Indexed;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.repository.Score;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SimpleSolrPersistentProperty
extends AnnotationBasedPersistentProperty<SolrPersistentProperty>
implements SolrPersistentProperty {
    private static final String SOLRJ_FIELD_ANNOTATION_DEFAULT_VALUE = "#default";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet(3);
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>(1);

    public SimpleSolrPersistentProperty(Property property, PersistentEntity<?, SolrPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
    }

    @Override
    public String getFieldName() {
        String fieldName = this.readAnnotatedFieldName();
        if (StringUtils.hasText((String)fieldName) && !SOLRJ_FIELD_ANNOTATION_DEFAULT_VALUE.equals(fieldName)) {
            return fieldName;
        }
        return this.getName();
    }

    private String readAnnotatedFieldName() {
        Indexed indexedAnnotation;
        String fieldName = null;
        if (this.isAnnotationPresent(Field.class)) {
            fieldName = ((Field)this.findAnnotation(Field.class)).value();
        } else if (this.isAnnotationPresent(Indexed.class) && (indexedAnnotation = (Indexed)this.findAnnotation(Indexed.class)) != null && !StringUtils.hasText((String)(fieldName = indexedAnnotation.value()))) {
            fieldName = indexedAnnotation.name();
        }
        return fieldName;
    }

    @Override
    public boolean isReadonly() {
        if (this.isIdProperty() || this.isVersionProperty()) {
            return false;
        }
        Indexed indexedAnnotation = this.getIndexAnnotation();
        if (indexedAnnotation != null && indexedAnnotation.readonly()) {
            return true;
        }
        return indexedAnnotation == null && this.getFieldAnnotation() == null;
    }

    public boolean isIdProperty() {
        return super.isIdProperty() || SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());
    }

    protected Association<SolrPersistentProperty> createAssociation() {
        return null;
    }

    @Override
    public boolean containsWildcard() {
        String fieldName = this.getFieldName();
        return fieldName != null ? fieldName.startsWith("*") || fieldName.endsWith("*") : false;
    }

    @Nullable
    private Field getFieldAnnotation() {
        return (Field)this.findAnnotation(Field.class);
    }

    @Nullable
    private Indexed getIndexAnnotation() {
        return (Indexed)this.findAnnotation(Indexed.class);
    }

    @Override
    public boolean isBoosted() {
        Float boost = this.getBoost();
        return boost != null && !Float.isNaN(boost.floatValue());
    }

    @Override
    @Nullable
    public Float getBoost() {
        Float boost = Float.valueOf(Float.NaN);
        Indexed indexedAnnotation = this.getIndexAnnotation();
        if (indexedAnnotation != null) {
            boost = Float.valueOf(indexedAnnotation.boost());
        }
        return Float.isNaN(boost.floatValue()) ? null : boost;
    }

    @Override
    public boolean isSearchable() {
        if (this.isIdProperty()) {
            return true;
        }
        Indexed indexedAnnotation = this.getIndexAnnotation();
        return indexedAnnotation != null && indexedAnnotation.searchable();
    }

    @Override
    public boolean isStored() {
        if (this.isIdProperty()) {
            return true;
        }
        Indexed indexedAnnotation = this.getIndexAnnotation();
        return indexedAnnotation != null && indexedAnnotation.stored();
    }

    @Override
    public boolean isMultiValued() {
        return this.isCollectionLike();
    }

    @Override
    public String getSolrTypeName() {
        Indexed indexedAnnotation = this.getIndexAnnotation();
        if (indexedAnnotation != null && StringUtils.hasText((String)indexedAnnotation.type())) {
            return indexedAnnotation.type();
        }
        return this.getActualType().getSimpleName().toLowerCase();
    }

    @Override
    public Object getDefaultValue() {
        Indexed indexedAnnotation = this.getIndexAnnotation();
        if (indexedAnnotation != null && StringUtils.hasText((String)indexedAnnotation.defaultValue())) {
            return indexedAnnotation.defaultValue();
        }
        return null;
    }

    @Override
    public Collection<String> getCopyFields() {
        Indexed indexedAnnotation = this.getIndexAnnotation();
        if (indexedAnnotation != null && indexedAnnotation.copyTo().length > 0) {
            return CollectionUtils.arrayToList((Object)indexedAnnotation.copyTo());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isUnique() {
        return this.isIdProperty();
    }

    @Override
    public boolean isRequired() {
        Indexed indexedAnnotation = this.getIndexAnnotation();
        return indexedAnnotation != null && indexedAnnotation.required();
    }

    @Override
    public boolean isScoreProperty() {
        return this.findAnnotation(Score.class) != null;
    }

    @Override
    public boolean isDynamicProperty() {
        return this.findAnnotation(Dynamic.class) != null;
    }

    @Override
    public boolean isChildProperty() {
        Field fieldAnnotation = this.getFieldAnnotation();
        if (fieldAnnotation != null && fieldAnnotation.child()) {
            return true;
        }
        return this.findAnnotation(ChildDocument.class) != null;
    }

    static {
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(Long.class);
        SUPPORTED_ID_TYPES.add(Integer.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
    }
}

