/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.dsl;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.integration.amqp.dsl.AmqpBaseOutboundEndpointSpec;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.util.Assert;

public class AmqpOutboundEndpointSpec
extends AmqpBaseOutboundEndpointSpec<AmqpOutboundEndpointSpec, AmqpOutboundEndpoint> {
    private final boolean expectReply;

    AmqpOutboundEndpointSpec(AmqpTemplate amqpTemplate, boolean expectReply) {
        this.expectReply = expectReply;
        this.target = new AmqpOutboundEndpoint(amqpTemplate);
        ((AmqpOutboundEndpoint)((Object)this.target)).setExpectReply(expectReply);
        ((AmqpOutboundEndpoint)((Object)this.target)).setHeaderMapper(this.headerMapper);
        if (expectReply) {
            ((AmqpOutboundEndpoint)((Object)this.target)).setRequiresReply(true);
        }
    }

    @Override
    public AmqpOutboundEndpointSpec mappedReplyHeaders(String ... headers) {
        Assert.isTrue((boolean)this.expectReply, (String)"'mappedReplyHeaders' can be applied only for gateway");
        return (AmqpOutboundEndpointSpec)((Object)super.mappedReplyHeaders(headers));
    }
}

