/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.ObjectUtils;

public class LookupOverride
extends MethodOverride {
    private final @Nullable String beanName;
    private @Nullable Method method;

    public LookupOverride(String methodName, @Nullable String beanName) {
        super(methodName);
        this.beanName = beanName;
    }

    public LookupOverride(Method method, @Nullable String beanName) {
        super(method.getName());
        this.method = method;
        this.beanName = beanName;
    }

    public @Nullable String getBeanName() {
        return this.beanName;
    }

    @Override
    public boolean matches(Method method) {
        if (this.method != null) {
            return method.equals(this.method);
        }
        return method.getName().equals(this.getMethodName()) && (!this.isOverloaded() || Modifier.isAbstract(method.getModifiers()) || method.getParameterCount() == 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LookupOverride)) return false;
        LookupOverride that = (LookupOverride)other;
        if (!super.equals(other)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.method, (Object)that.method)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)that.beanName)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 29 + ObjectUtils.nullSafeHashCode((Object)this.beanName);
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'";
    }
}

