/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.Assert;

public class StatusResultMatchers {
    protected StatusResultMatchers() {
    }

    public ResultMatcher is(Matcher<? super Integer> matcher) {
        return result -> MatcherAssert.assertThat((String)"Response status", (Object)result.getResponse().getStatus(), (Matcher)matcher);
    }

    public ResultMatcher is(int status) {
        return result -> AssertionErrors.assertEquals("Response status", status, result.getResponse().getStatus());
    }

    public ResultMatcher is1xxInformational() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.INFORMATIONAL, this.getHttpStatusSeries(result));
    }

    public ResultMatcher is2xxSuccessful() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.SUCCESSFUL, this.getHttpStatusSeries(result));
    }

    public ResultMatcher is3xxRedirection() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.REDIRECTION, this.getHttpStatusSeries(result));
    }

    public ResultMatcher is4xxClientError() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.CLIENT_ERROR, this.getHttpStatusSeries(result));
    }

    public ResultMatcher is5xxServerError() {
        return result -> AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.SERVER_ERROR, this.getHttpStatusSeries(result));
    }

    private HttpStatus.Series getHttpStatusSeries(MvcResult result) {
        HttpStatus.Series series = HttpStatus.Series.resolve((int)result.getResponse().getStatus());
        Assert.state((series != null ? 1 : 0) != 0, (String)"HTTP status series must not be null");
        return series;
    }

    public ResultMatcher reason(Matcher<? super String> matcher) {
        return result -> MatcherAssert.assertThat((String)"Response status reason", (Object)result.getResponse().getErrorMessage(), (Matcher)matcher);
    }

    public ResultMatcher reason(String reason) {
        return result -> AssertionErrors.assertEquals("Response status reason", reason, result.getResponse().getErrorMessage());
    }

    public ResultMatcher isContinue() {
        return this.matcher((HttpStatusCode)HttpStatus.CONTINUE);
    }

    public ResultMatcher isSwitchingProtocols() {
        return this.matcher((HttpStatusCode)HttpStatus.SWITCHING_PROTOCOLS);
    }

    @Deprecated(since="7.0")
    public ResultMatcher isProcessing() {
        return this.matcher((HttpStatusCode)HttpStatus.PROCESSING);
    }

    public ResultMatcher isEarlyHints() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)103));
    }

    public ResultMatcher isOk() {
        return this.matcher((HttpStatusCode)HttpStatus.OK);
    }

    public ResultMatcher isCreated() {
        return this.matcher((HttpStatusCode)HttpStatus.CREATED);
    }

    public ResultMatcher isAccepted() {
        return this.matcher((HttpStatusCode)HttpStatus.ACCEPTED);
    }

    public ResultMatcher isNonAuthoritativeInformation() {
        return this.matcher((HttpStatusCode)HttpStatus.NON_AUTHORITATIVE_INFORMATION);
    }

    public ResultMatcher isNoContent() {
        return this.matcher((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    public ResultMatcher isResetContent() {
        return this.matcher((HttpStatusCode)HttpStatus.RESET_CONTENT);
    }

    public ResultMatcher isPartialContent() {
        return this.matcher((HttpStatusCode)HttpStatus.PARTIAL_CONTENT);
    }

    public ResultMatcher isMultiStatus() {
        return this.matcher((HttpStatusCode)HttpStatus.MULTI_STATUS);
    }

    public ResultMatcher isAlreadyReported() {
        return this.matcher((HttpStatusCode)HttpStatus.ALREADY_REPORTED);
    }

    public ResultMatcher isImUsed() {
        return this.matcher((HttpStatusCode)HttpStatus.IM_USED);
    }

    public ResultMatcher isMultipleChoices() {
        return this.matcher((HttpStatusCode)HttpStatus.MULTIPLE_CHOICES);
    }

    public ResultMatcher isMovedPermanently() {
        return this.matcher((HttpStatusCode)HttpStatus.MOVED_PERMANENTLY);
    }

    public ResultMatcher isFound() {
        return this.matcher((HttpStatusCode)HttpStatus.FOUND);
    }

    public ResultMatcher isSeeOther() {
        return this.matcher((HttpStatusCode)HttpStatus.SEE_OTHER);
    }

    public ResultMatcher isNotModified() {
        return this.matcher((HttpStatusCode)HttpStatus.NOT_MODIFIED);
    }

    public ResultMatcher isTemporaryRedirect() {
        return this.matcher((HttpStatusCode)HttpStatus.TEMPORARY_REDIRECT);
    }

    public ResultMatcher isPermanentRedirect() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)308));
    }

    public ResultMatcher isBadRequest() {
        return this.matcher((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public ResultMatcher isUnauthorized() {
        return this.matcher((HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    public ResultMatcher isPaymentRequired() {
        return this.matcher((HttpStatusCode)HttpStatus.PAYMENT_REQUIRED);
    }

    public ResultMatcher isForbidden() {
        return this.matcher((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    public ResultMatcher isNotFound() {
        return this.matcher((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public ResultMatcher isMethodNotAllowed() {
        return this.matcher((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED);
    }

    public ResultMatcher isNotAcceptable() {
        return this.matcher((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE);
    }

    public ResultMatcher isProxyAuthenticationRequired() {
        return this.matcher((HttpStatusCode)HttpStatus.PROXY_AUTHENTICATION_REQUIRED);
    }

    public ResultMatcher isRequestTimeout() {
        return this.matcher((HttpStatusCode)HttpStatus.REQUEST_TIMEOUT);
    }

    public ResultMatcher isConflict() {
        return this.matcher((HttpStatusCode)HttpStatus.CONFLICT);
    }

    public ResultMatcher isGone() {
        return this.matcher((HttpStatusCode)HttpStatus.GONE);
    }

    public ResultMatcher isLengthRequired() {
        return this.matcher((HttpStatusCode)HttpStatus.LENGTH_REQUIRED);
    }

    public ResultMatcher isPreconditionFailed() {
        return this.matcher((HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    public ResultMatcher isContentTooLarge() {
        return this.matcher((HttpStatusCode)HttpStatus.CONTENT_TOO_LARGE);
    }

    @Deprecated(since="7.0")
    public ResultMatcher isPayloadTooLarge() {
        return this.matcher((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE);
    }

    public ResultMatcher isUriTooLong() {
        return this.matcher((HttpStatusCode)HttpStatus.URI_TOO_LONG);
    }

    public ResultMatcher isUnsupportedMediaType() {
        return this.matcher((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    public ResultMatcher isRequestedRangeNotSatisfiable() {
        return this.matcher((HttpStatusCode)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
    }

    public ResultMatcher isExpectationFailed() {
        return this.matcher((HttpStatusCode)HttpStatus.EXPECTATION_FAILED);
    }

    @Deprecated(since="7.0")
    public ResultMatcher isIAmATeapot() {
        return this.matcher((HttpStatusCode)HttpStatus.I_AM_A_TEAPOT);
    }

    public ResultMatcher isMisdirectedRequest() {
        return this.matcher((HttpStatusCode)HttpStatus.MISDIRECTED_REQUEST);
    }

    public ResultMatcher isUnprocessableContent() {
        return this.matcher((HttpStatusCode)HttpStatus.UNPROCESSABLE_CONTENT);
    }

    @Deprecated(since="7.0")
    public ResultMatcher isUnprocessableEntity() {
        return this.matcher((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public ResultMatcher isLocked() {
        return this.matcher((HttpStatusCode)HttpStatus.LOCKED);
    }

    public ResultMatcher isFailedDependency() {
        return this.matcher((HttpStatusCode)HttpStatus.FAILED_DEPENDENCY);
    }

    public ResultMatcher isTooEarly() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)425));
    }

    public ResultMatcher isUpgradeRequired() {
        return this.matcher((HttpStatusCode)HttpStatus.UPGRADE_REQUIRED);
    }

    public ResultMatcher isPreconditionRequired() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)428));
    }

    public ResultMatcher isTooManyRequests() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)429));
    }

    public ResultMatcher isRequestHeaderFieldsTooLarge() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)431));
    }

    public ResultMatcher isUnavailableForLegalReasons() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)451));
    }

    public ResultMatcher isInternalServerError() {
        return this.matcher((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ResultMatcher isNotImplemented() {
        return this.matcher((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    public ResultMatcher isBadGateway() {
        return this.matcher((HttpStatusCode)HttpStatus.BAD_GATEWAY);
    }

    public ResultMatcher isServiceUnavailable() {
        return this.matcher((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
    }

    public ResultMatcher isGatewayTimeout() {
        return this.matcher((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT);
    }

    public ResultMatcher isHttpVersionNotSupported() {
        return this.matcher((HttpStatusCode)HttpStatus.HTTP_VERSION_NOT_SUPPORTED);
    }

    public ResultMatcher isVariantAlsoNegotiates() {
        return this.matcher((HttpStatusCode)HttpStatus.VARIANT_ALSO_NEGOTIATES);
    }

    public ResultMatcher isInsufficientStorage() {
        return this.matcher((HttpStatusCode)HttpStatus.INSUFFICIENT_STORAGE);
    }

    public ResultMatcher isLoopDetected() {
        return this.matcher((HttpStatusCode)HttpStatus.LOOP_DETECTED);
    }

    @Deprecated(since="7.0")
    public ResultMatcher isBandwidthLimitExceeded() {
        return this.matcher((HttpStatusCode)HttpStatus.BANDWIDTH_LIMIT_EXCEEDED);
    }

    @Deprecated(since="7.0")
    public ResultMatcher isNotExtended() {
        return this.matcher((HttpStatusCode)HttpStatus.NOT_EXTENDED);
    }

    public ResultMatcher isNetworkAuthenticationRequired() {
        return this.matcher((HttpStatusCode)HttpStatus.valueOf((int)511));
    }

    private ResultMatcher matcher(HttpStatusCode status) {
        return result -> AssertionErrors.assertEquals("Status", status.value(), result.getResponse().getStatus());
    }
}

