/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Conventions;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;

public class ServletTestExecutionListener
extends AbstractTestExecutionListener {
    public static final int ORDER = 1000;
    public static final String RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE = Conventions.getQualifiedAttributeName(ServletTestExecutionListener.class, (String)"resetRequestContextHolder");
    public static final String POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE = Conventions.getQualifiedAttributeName(ServletTestExecutionListener.class, (String)"populatedRequestContextHolder");
    public static final String CREATED_BY_THE_TESTCONTEXT_FRAMEWORK = Conventions.getQualifiedAttributeName(ServletTestExecutionListener.class, (String)"createdByTheTestContextFramework");
    public static final String ACTIVATE_LISTENER = Conventions.getQualifiedAttributeName(ServletTestExecutionListener.class, (String)"activateListener");
    private static final Log logger = LogFactory.getLog(ServletTestExecutionListener.class);

    @Override
    public final int getOrder() {
        return 1000;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.setUpRequestContextIfNecessary(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.setUpRequestContextIfNecessary(testContext);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE))) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resetting RequestContextHolder for test context " + String.valueOf(testContext)));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resetting RequestContextHolder for test class " + testContext.getTestClass().getName()));
            }
            RequestContextHolder.resetRequestAttributes();
            testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
        }
        testContext.removeAttribute(POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE);
        testContext.removeAttribute(RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE);
    }

    private boolean isActivated(TestContext testContext) {
        return Boolean.TRUE.equals(testContext.getAttribute(ACTIVATE_LISTENER)) || AnnotatedElementUtils.hasAnnotation(testContext.getTestClass(), WebAppConfiguration.class);
    }

    private boolean alreadyPopulatedRequestContextHolder(TestContext testContext) {
        return Boolean.TRUE.equals(testContext.getAttribute(POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE));
    }

    private void setUpRequestContextIfNecessary(TestContext testContext) {
        if (!this.isActivated(testContext) || this.alreadyPopulatedRequestContextHolder(testContext)) {
            return;
        }
        ApplicationContext context = testContext.getApplicationContext();
        if (context instanceof WebApplicationContext) {
            WebApplicationContext wac = (WebApplicationContext)context;
            ServletContext servletContext = wac.getServletContext();
            if (!(servletContext instanceof MockServletContext)) {
                throw new IllegalStateException("The WebApplicationContext for test context %s must be configured with a MockServletContext.".formatted(testContext));
            }
            MockServletContext mockServletContext = (MockServletContext)servletContext;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Setting up MockHttpServletRequest, MockHttpServletResponse, ServletWebRequest, and RequestContextHolder for test context " + String.valueOf(testContext)));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting up MockHttpServletRequest, MockHttpServletResponse, ServletWebRequest, and RequestContextHolder for test class " + testContext.getTestClass().getName()));
            }
            MockHttpServletRequest request = new MockHttpServletRequest(mockServletContext);
            request.setAttribute(CREATED_BY_THE_TESTCONTEXT_FRAMEWORK, Boolean.TRUE);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletWebRequest servletWebRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)response);
            RequestContextHolder.setRequestAttributes((RequestAttributes)servletWebRequest);
            testContext.setAttribute(POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE, Boolean.TRUE);
            testContext.setAttribute(RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE, Boolean.TRUE);
            if (wac instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)wac;
                ConfigurableListableBeanFactory bf = configurableApplicationContext.getBeanFactory();
                bf.registerResolvableDependency(MockHttpServletResponse.class, (Object)response);
                bf.registerResolvableDependency(ServletWebRequest.class, (Object)servletWebRequest);
            }
        }
    }
}

