/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.test.json.JsonAssert;
import org.springframework.test.json.JsonComparator;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.ExceptionCollector;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.servlet.client.CookieAssertions;
import org.springframework.test.web.servlet.client.DefaultRestTestClientBuilder;
import org.springframework.test.web.servlet.client.EntityExchangeResult;
import org.springframework.test.web.servlet.client.ExchangeResult;
import org.springframework.test.web.servlet.client.HeaderAssertions;
import org.springframework.test.web.servlet.client.JsonPathAssertions;
import org.springframework.test.web.servlet.client.RestTestClient;
import org.springframework.test.web.servlet.client.StatusAssertions;
import org.springframework.test.web.servlet.client.XpathAssertions;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

class DefaultRestTestClient
implements RestTestClient {
    private final RestClient restClient;
    private final WiretapInterceptor wiretapInterceptor = new WiretapInterceptor();
    private final Consumer<EntityExchangeResult<?>> entityResultConsumer;
    private final DefaultRestTestClientBuilder<?> restTestClientBuilder;
    private final @Nullable JsonConverterDelegate converterDelegate;
    private final AtomicLong requestIndex = new AtomicLong();

    DefaultRestTestClient(RestClient.Builder builder, Consumer<EntityExchangeResult<?>> entityResultConsumer, DefaultRestTestClientBuilder<?> restTestClientBuilder) {
        this.restClient = builder.requestInterceptor((ClientHttpRequestInterceptor)this.wiretapInterceptor).build();
        this.entityResultConsumer = entityResultConsumer;
        this.restTestClientBuilder = restTestClientBuilder;
        this.converterDelegate = new ConverterCallback(this.restClient).getConverter();
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private RestTestClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        return new DefaultRequestBodyUriSpec(this.restClient.method(httpMethod));
    }

    @Override
    public <B extends RestTestClient.Builder<B>> RestTestClient.Builder<B> mutate() {
        return new DefaultRestTestClientBuilder(this.restTestClientBuilder);
    }

    private static class WiretapInterceptor
    implements ClientHttpRequestInterceptor {
        private final Map<String, byte[]> requestContentMap = new ConcurrentHashMap<String, byte[]>();

        private WiretapInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) throws IOException {
            String header = "RestTestClient-Request-Id";
            String requestId = request.getHeaders().getFirst(header);
            Assert.state((requestId != null ? 1 : 0) != 0, () -> "No \"" + header + "\" header");
            this.requestContentMap.put(requestId, body2);
            return execution.execute(request, body2);
        }

        public byte[] getRequestContent(String requestId) {
            byte[] bytes = this.requestContentMap.remove(requestId);
            Assert.state((bytes != null ? 1 : 0) != 0, () -> "No match for %s=%s".formatted("RestTestClient-Request-Id", requestId));
            return bytes;
        }
    }

    private static class ConverterCallback {
        private @Nullable JsonConverterDelegate converter;

        ConverterCallback(RestClient client) {
            client.mutate().configureMessageConverters(convertersBuilder -> {
                HttpMessageConverters converters = convertersBuilder.build();
                if (converters.isEmpty()) {
                    converters = ((HttpMessageConverters.ClientBuilder)HttpMessageConverters.forClient().registerDefaults()).build();
                }
                this.converter = JsonConverterDelegate.of(converters);
            }).build();
        }

        public @Nullable JsonConverterDelegate getConverter() {
            return this.converter;
        }
    }

    private class DefaultRequestBodyUriSpec
    implements RestTestClient.RequestBodyUriSpec {
        private final RestClient.RequestBodyUriSpec requestHeadersUriSpec;
        private final String requestId;
        private @Nullable String uriTemplate;

        DefaultRequestBodyUriSpec(RestClient.RequestBodyUriSpec spec) {
            this.requestHeadersUriSpec = spec;
            this.requestId = String.valueOf(DefaultRestTestClient.this.requestIndex.incrementAndGet());
            this.requestHeadersUriSpec.header("RestTestClient-Request-Id", new String[]{this.requestId});
        }

        @Override
        public RestTestClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.uriTemplate = uriTemplate;
            this.requestHeadersUriSpec.uri(uriTemplate, uriVariables);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec uri(String uri, Map<String, ?> uriVariables) {
            this.uriTemplate = uri;
            this.requestHeadersUriSpec.uri(uri, uriVariables);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            this.uriTemplate = null;
            this.requestHeadersUriSpec.uri(uriFunction);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec uri(URI uri) {
            this.uriTemplate = null;
            this.requestHeadersUriSpec.uri(uri);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec header(String headerName, String ... headerValues) {
            this.requestHeadersUriSpec.header(headerName, headerValues);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec headers(Consumer<HttpHeaders> headersConsumer) {
            this.requestHeadersUriSpec.headers(headersConsumer);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec accept(MediaType ... acceptableMediaTypes) {
            this.requestHeadersUriSpec.accept(acceptableMediaTypes);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec acceptCharset(Charset ... acceptableCharsets) {
            this.requestHeadersUriSpec.acceptCharset(acceptableCharsets);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec contentType(MediaType contentType) {
            this.requestHeadersUriSpec.contentType(contentType);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec contentLength(long contentLength) {
            this.requestHeadersUriSpec.contentLength(contentLength);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec cookie(String name, String value) {
            this.requestHeadersUriSpec.cookie(name, value);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            this.requestHeadersUriSpec.cookies(cookiesConsumer);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.requestHeadersUriSpec.ifModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec ifNoneMatch(String ... ifNoneMatches) {
            this.requestHeadersUriSpec.ifNoneMatch(ifNoneMatches);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec attribute(String name, Object value) {
            this.requestHeadersUriSpec.attribute(name, value);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            this.requestHeadersUriSpec.attributes(attributesConsumer);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec apiVersion(@Nullable Object version) {
            this.requestHeadersUriSpec.apiVersion(version);
            return this;
        }

        @Override
        public RestTestClient.RequestHeadersSpec<?> body(Object body2) {
            this.requestHeadersUriSpec.body(body2);
            return this;
        }

        @Override
        public RestTestClient.ResponseSpec exchange() {
            return new DefaultResponseSpec((ExchangeResult)this.requestHeadersUriSpec.exchangeForRequiredValue((request, response) -> {
                byte[] requestBody = DefaultRestTestClient.this.wiretapInterceptor.getRequestContent(this.requestId);
                return new ExchangeResult(request, response, this.uriTemplate, requestBody, DefaultRestTestClient.this.converterDelegate);
            }, false), DefaultRestTestClient.this.entityResultConsumer);
        }

        @Override
        public RestTestClient.ResponseSpec exchangeSuccessfully() {
            return (RestTestClient.ResponseSpec)this.exchange().expectStatus().is2xxSuccessful();
        }
    }

    private record MessageConverterMappingProvider(JsonConverterDelegate delegate) implements MappingProvider
    {
        public <T> T map(Object value, Class<T> targetType, Configuration configuration) {
            return this.mapToTargetType(value, ResolvableType.forClass(targetType));
        }

        public <T> T map(Object value, TypeRef<T> targetType, Configuration configuration) {
            return this.mapToTargetType(value, ResolvableType.forType((Type)targetType.getType()));
        }

        private <T> T mapToTargetType(Object value, ResolvableType targetType) {
            try {
                return this.delegate().map(value, targetType);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to map " + String.valueOf(value) + " to " + String.valueOf(targetType), ex);
            }
        }
    }

    private static class JsonPathConfigurationProvider {
        private JsonPathConfigurationProvider() {
        }

        static Configuration getConfiguration(EntityExchangeResult<?> result) {
            Configuration config = Configuration.defaultConfiguration();
            JsonConverterDelegate delegate = result.getJsonConverterDelegate();
            return delegate != null ? config.mappingProvider((MappingProvider)new MessageConverterMappingProvider(delegate)) : config;
        }
    }

    private static class DefaultBodyContentSpec
    implements RestTestClient.BodyContentSpec {
        private final EntityExchangeResult<byte[]> result;

        DefaultBodyContentSpec(EntityExchangeResult<byte[]> result) {
            this.result = result;
        }

        @Override
        public EntityExchangeResult<Void> isEmpty() {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Expected empty body", this.result.getResponseBody() == null));
            return new EntityExchangeResult<Object>(this.result, null);
        }

        @Override
        public RestTestClient.BodyContentSpec json(String expectedJson, JsonCompareMode compareMode) {
            return this.json(expectedJson, JsonAssert.comparator(compareMode));
        }

        @Override
        public RestTestClient.BodyContentSpec json(String expectedJson, JsonComparator comparator) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    comparator.assertIsMatch(expectedJson, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("JSON parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public RestTestClient.BodyContentSpec xml(String expectedXml) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    new XmlExpectationsHelper().assertXmlEqual(expectedXml, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("XML parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public JsonPathAssertions jsonPath(String expression) {
            Configuration config = JsonPathConfigurationProvider.getConfiguration(this.result);
            return new JsonPathAssertions(this, this.getBodyAsString(), expression, config);
        }

        @Override
        public XpathAssertions xpath(String expression, @Nullable Map<String, String> namespaces, Object ... args) {
            return new XpathAssertions(this, expression, namespaces, args);
        }

        private String getBodyAsString() {
            byte[] body2 = this.result.getResponseBody();
            if (body2 == null || body2.length == 0) {
                return "";
            }
            Charset charset = Optional.ofNullable(this.result.getResponseHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
            return new String(body2, charset);
        }

        @Override
        public RestTestClient.BodyContentSpec consumeWith(Consumer<EntityExchangeResult<byte[]>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this;
        }

        @Override
        public EntityExchangeResult<byte[]> returnResult() {
            return this.result;
        }
    }

    private static class DefaultBodySpec<B, S extends RestTestClient.BodySpec<B, S>>
    implements RestTestClient.BodySpec<B, S> {
        private final EntityExchangeResult<B> result;

        DefaultBodySpec(EntityExchangeResult<B> result) {
            this.result = result;
        }

        @Override
        public <T extends S> T isEqualTo(@Nullable B expected) {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S> T value(Consumer<@Nullable B> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S, R> T value(Function<@Nullable B, @Nullable R> bodyMapper, Consumer<? super @Nullable R> consumer) {
            this.result.assertWithDiagnostics(() -> {
                B body2 = this.result.getResponseBody();
                consumer.accept((Object)bodyMapper.apply(body2));
            });
            return this.self();
        }

        @Override
        public <T extends S> T consumeWith(Consumer<EntityExchangeResult<B>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this.self();
        }

        private <T extends S> T self() {
            return (T)this;
        }

        @Override
        public EntityExchangeResult<B> returnResult() {
            return this.result;
        }
    }

    private static class DefaultResponseSpec
    implements RestTestClient.ResponseSpec {
        private final ExchangeResult exchangeResult;
        private final Consumer<EntityExchangeResult<?>> entityResultConsumer;

        DefaultResponseSpec(ExchangeResult result, Consumer<EntityExchangeResult<?>> entityResultConsumer) {
            this.exchangeResult = result;
            this.entityResultConsumer = entityResultConsumer;
        }

        @Override
        public StatusAssertions expectStatus() {
            return new StatusAssertions(this.exchangeResult, this);
        }

        @Override
        public HeaderAssertions expectHeader() {
            return new HeaderAssertions(this.exchangeResult, this);
        }

        @Override
        public CookieAssertions expectCookie() {
            return new CookieAssertions(this.exchangeResult, this);
        }

        @Override
        public <B> RestTestClient.BodySpec<B, ?> expectBody(Class<B> bodyType) {
            Object body2 = this.exchangeResult.getClientResponse().bodyTo(bodyType);
            EntityExchangeResult<Object> result = new EntityExchangeResult<Object>(this.exchangeResult, body2);
            return new DefaultBodySpec(result);
        }

        @Override
        public <B> RestTestClient.BodySpec<B, ?> expectBody(ParameterizedTypeReference<B> bodyType) {
            Object body2 = this.exchangeResult.getClientResponse().bodyTo(bodyType);
            EntityExchangeResult<Object> result = this.initExchangeResult(body2);
            return new DefaultBodySpec(result);
        }

        @Override
        public RestTestClient.BodyContentSpec expectBody() {
            byte[] body2 = (byte[])this.exchangeResult.getClientResponse().bodyTo(byte[].class);
            EntityExchangeResult<byte[]> result = this.initExchangeResult(body2);
            return new DefaultBodyContentSpec(result);
        }

        @Override
        public <T> EntityExchangeResult<T> returnResult(Class<T> elementClass) {
            return this.initExchangeResult(this.exchangeResult.getClientResponse().bodyTo(elementClass));
        }

        @Override
        public <T> EntityExchangeResult<T> returnResult(ParameterizedTypeReference<T> elementTypeRef) {
            return this.initExchangeResult(this.exchangeResult.getClientResponse().bodyTo(elementTypeRef));
        }

        private <B> EntityExchangeResult<B> initExchangeResult(@Nullable B body2) {
            EntityExchangeResult result = new EntityExchangeResult(this.exchangeResult, body2);
            result.assertWithDiagnostics(() -> this.entityResultConsumer.accept(result));
            return result;
        }

        @Override
        public RestTestClient.ResponseSpec expectAll(RestTestClient.ResponseSpec.ResponseSpecConsumer ... consumers) {
            ExceptionCollector exceptionCollector = new ExceptionCollector();
            for (RestTestClient.ResponseSpec.ResponseSpecConsumer consumer : consumers) {
                exceptionCollector.execute(() -> consumer.accept(this));
            }
            try {
                exceptionCollector.assertEmpty();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AssertionError(ex.getMessage(), ex);
            }
            return this;
        }
    }
}

