/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import com.jayway.jsonpath.Configuration;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.util.Assert;

public abstract class AbstractJsonPathAssertions<B> {
    private final B bodySpec;
    private final String content;
    private final JsonPathExpectationsHelper pathHelper;

    protected AbstractJsonPathAssertions(B spec, String content, String expression, @Nullable Configuration configuration) {
        Assert.hasText((String)expression, (String)"expression must not be null or empty");
        this.bodySpec = spec;
        this.content = content;
        this.pathHelper = new JsonPathExpectationsHelper(expression, configuration);
    }

    protected B getBodySpec() {
        return this.bodySpec;
    }

    protected String getContent() {
        return this.content;
    }

    protected JsonPathExpectationsHelper getPathHelper() {
        return this.pathHelper;
    }

    public B isEqualTo(@Nullable Object expectedValue) {
        this.pathHelper.assertValue(this.content, expectedValue);
        return this.bodySpec;
    }

    public B exists() {
        this.pathHelper.exists(this.content);
        return this.bodySpec;
    }

    public B doesNotExist() {
        this.pathHelper.doesNotExist(this.content);
        return this.bodySpec;
    }

    public B isEmpty() {
        this.pathHelper.assertValueIsEmpty(this.content);
        return this.bodySpec;
    }

    public B isNotEmpty() {
        this.pathHelper.assertValueIsNotEmpty(this.content);
        return this.bodySpec;
    }

    public B hasJsonPath() {
        this.pathHelper.hasJsonPath(this.content);
        return this.bodySpec;
    }

    public B doesNotHaveJsonPath() {
        this.pathHelper.doesNotHaveJsonPath(this.content);
        return this.bodySpec;
    }

    public B isBoolean() {
        this.pathHelper.assertValueIsBoolean(this.content);
        return this.bodySpec;
    }

    public B isNumber() {
        this.pathHelper.assertValueIsNumber(this.content);
        return this.bodySpec;
    }

    public B isArray() {
        this.pathHelper.assertValueIsArray(this.content);
        return this.bodySpec;
    }

    public B isMap() {
        this.pathHelper.assertValueIsMap(this.content);
        return this.bodySpec;
    }

    public <T> B value(Consumer<T> consumer) {
        Object value = this.pathHelper.evaluateJsonPath(this.content);
        consumer.accept(value);
        return this.bodySpec;
    }

    public <T> B value(Class<T> targetType, Consumer<T> consumer) {
        T value = this.pathHelper.evaluateJsonPath(this.content, targetType);
        consumer.accept(value);
        return this.bodySpec;
    }

    public <T> B value(ParameterizedTypeReference<T> targetType, Consumer<T> consumer) {
        T value = this.pathHelper.evaluateJsonPath(this.content, targetType);
        consumer.accept(value);
        return this.bodySpec;
    }

    public boolean equals(@Nullable Object obj) {
        throw new AssertionError((Object)"Object#equals is disabled to avoid being used in error instead of JsonPathAssertions#isEqualTo(String).");
    }

    public int hashCode() {
        return super.hashCode();
    }
}

