/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.web.context.support.RequestHandledEvent;

public class ServletRequestHandledEvent
extends RequestHandledEvent {
    private final String requestUrl;
    private final String clientAddress;
    private final String method;
    private final String servletName;

    public ServletRequestHandledEvent(Object source, String requestUrl, String clientAddress, String method, String servletName, String sessionId, String userName, long processingTimeMillis) {
        super(source, sessionId, userName, processingTimeMillis);
        this.requestUrl = requestUrl;
        this.clientAddress = clientAddress;
        this.method = method;
        this.servletName = servletName;
    }

    public ServletRequestHandledEvent(Object source, String requestUrl, String clientAddress, String method, String servletName, String sessionId, String userName, long processingTimeMillis, Throwable failureCause) {
        super(source, sessionId, userName, processingTimeMillis, failureCause);
        this.requestUrl = requestUrl;
        this.clientAddress = clientAddress;
        this.method = method;
        this.servletName = servletName;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getMethod() {
        return this.method;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("url=[").append(this.getRequestUrl()).append("]; ");
        sb.append("client=[").append(this.getClientAddress()).append("]; ");
        sb.append(super.getShortDescription());
        return sb.toString();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("url=[").append(this.getRequestUrl()).append("]; ");
        sb.append("client=[").append(this.getClientAddress()).append("]; ");
        sb.append("method=[").append(this.getMethod()).append("]; ");
        sb.append("servlet=[").append(this.getServletName()).append("]; ");
        sb.append(super.getDescription());
        return sb.toString();
    }

    public String toString() {
        return "ServletRequestHandledEvent: " + this.getDescription();
    }
}

