/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import java.util.List;
import org.springframework.binding.expression.el.MapAdaptableELResolver;

public class DefaultELResolver
extends CompositeELResolver {
    private Object target;

    public DefaultELResolver(List<? extends ELResolver> customResolvers) {
        this(null, customResolvers);
    }

    public DefaultELResolver(Object target, List<? extends ELResolver> customResolvers) {
        this.target = target;
        this.configureResolvers(customResolvers);
    }

    public Object getTarget() {
        return this.target;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null) {
            return super.getType(context, this.target, property);
        }
        return super.getType(context, base, property);
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            return super.getValue(context, this.target, property);
        }
        return super.getValue(context, base, property);
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (base == null) {
            super.setValue(context, this.target, property, val);
        } else {
            super.setValue(context, base, property, val);
        }
    }

    private void configureResolvers(List<? extends ELResolver> customResolvers) {
        if (customResolvers != null) {
            for (ELResolver eLResolver : customResolvers) {
                this.add(eLResolver);
            }
        }
        this.add(new MapAdaptableELResolver());
        this.add((ELResolver)new ArrayELResolver());
        this.add((ELResolver)new ListELResolver());
        this.add((ELResolver)new MapELResolver());
        this.add((ELResolver)new ResourceBundleELResolver());
        this.add((ELResolver)new BeanELResolver());
    }
}

