/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientTioConfig;
import org.tio.cluster.TioClusterConfig;
import org.tio.cluster.TioClusterMessageListener;
import org.tio.core.ChannelContext;
import org.tio.core.DefaultTioUuid;
import org.tio.core.PacketConverter;
import org.tio.core.PacketHandlerMode;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.Packet;
import org.tio.core.intf.TioUuid;
import org.tio.core.maintain.BsIds;
import org.tio.core.maintain.ClientNodes;
import org.tio.core.maintain.Groups;
import org.tio.core.maintain.Ids;
import org.tio.core.maintain.IpBlacklist;
import org.tio.core.maintain.IpStats;
import org.tio.core.maintain.Ips;
import org.tio.core.maintain.Tokens;
import org.tio.core.maintain.Users;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.DefaultIpStatListener;
import org.tio.core.stat.GroupStat;
import org.tio.core.stat.IpStatListener;
import org.tio.core.task.CloseRunnable;
import org.tio.server.ServerTioConfig;
import org.tio.utils.SystemTimer;
import org.tio.utils.Threads;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.prop.MapWithLockPropSupport;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public abstract class TioConfig
extends MapWithLockPropSupport {
    static Logger log = LoggerFactory.getLogger(TioConfig.class);
    public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 20480);
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    public boolean isShortConnection = false;
    public SslConfig sslConfig = null;
    public boolean debug = false;
    public GroupStat groupStat = null;
    public boolean statOn = true;
    public PacketConverter packetConverter = null;
    public static final Set<ServerTioConfig> ALL_SERVER_GROUPCONTEXTS = new HashSet<ServerTioConfig>();
    public static final Set<ClientTioConfig> ALL_CLIENT_GROUPCONTEXTS = new HashSet<ClientTioConfig>();
    public static final Set<TioConfig> ALL_GROUPCONTEXTS = new HashSet<TioConfig>();
    public long startTime = SystemTimer.currTime;
    public boolean useQueueSend = true;
    public boolean useQueueDecode = false;
    public long heartbeatTimeout = 120000L;
    public boolean logWhenDecodeError = false;
    public PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;
    private int readBufferSize = READ_BUFFER_SIZE;
    private GroupListener groupListener = null;
    private TioUuid tioUuid = new DefaultTioUuid();
    public SynThreadPoolExecutor tioExecutor = null;
    public CloseRunnable closeRunnable;
    public ThreadPoolExecutor groupExecutor = null;
    public ClientNodes clientNodes = new ClientNodes();
    public SetWithLock<ChannelContext> connections = new SetWithLock(new HashSet());
    public Groups groups = new Groups();
    public Users users = new Users();
    public Tokens tokens = new Tokens();
    public Ids ids = new Ids();
    public BsIds bsIds = new BsIds();
    public Ips ips = new Ips();
    public IpStats ipStats = null;
    protected String id;
    protected int maxDecodeErrorCountForIp = 10;
    protected String name = "\u672a\u547d\u540d";
    private IpStatListener ipStatListener = DefaultIpStatListener.me;
    private boolean isStopped = false;
    public IpBlacklist ipBlacklist = null;
    public MapWithLock<Integer, Packet> waitingResps = new MapWithLock(new HashMap());
    private TioClusterConfig tioClusterConfig = null;

    public TioConfig() {
        this(null, null);
    }

    public TioConfig(SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        ALL_GROUPCONTEXTS.add(this);
        if (this instanceof ServerTioConfig) {
            ALL_SERVER_GROUPCONTEXTS.add((ServerTioConfig)this);
        } else {
            ALL_CLIENT_GROUPCONTEXTS.add((ClientTioConfig)this);
        }
        if (ALL_GROUPCONTEXTS.size() > 20) {
            log.warn("\u5df2\u7ecf\u4ea7\u751f{}\u4e2aTioConfig\u5bf9\u8c61\uff0ct-io\u4f5c\u8005\u6000\u7591\u4f60\u5728\u8bef\u7528t-io", (Object)ALL_GROUPCONTEXTS.size());
        }
        this.id = ID_ATOMIC.incrementAndGet() + "";
        this.ipStats = new IpStats(this, null);
        this.tioExecutor = tioExecutor;
        if (this.tioExecutor == null) {
            this.tioExecutor = Threads.getTioExecutor();
        }
        this.groupExecutor = groupExecutor;
        if (this.groupExecutor == null) {
            this.groupExecutor = Threads.getGroupExecutor();
        }
        this.closeRunnable = new CloseRunnable((Executor)this.tioExecutor);
    }

    public abstract AioHandler getAioHandler();

    public abstract AioListener getAioListener();

    public boolean isCluster() {
        return this.tioClusterConfig != null;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public GroupListener getGroupListener() {
        return this.groupListener;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TioUuid getTioUuid() {
        return this.tioUuid;
    }

    public MapWithLock<Integer, Packet> getWaitingResps() {
        return this.waitingResps;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setGroupListener(GroupListener groupListener) {
        this.groupListener = groupListener;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
        this.packetHandlerMode = packetHandlerMode;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = Math.min(readBufferSize, 132476);
    }

    public void setShortConnection(boolean isShortConnection) {
        this.isShortConnection = isShortConnection;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void setTioUuid(TioUuid tioUuid) {
        this.tioUuid = tioUuid;
    }

    public TioClusterConfig getTioClusterConfig() {
        return this.tioClusterConfig;
    }

    public void setTioClusterConfig(TioClusterConfig tioClusterConfig) {
        this.tioClusterConfig = tioClusterConfig;
        if (this.tioClusterConfig != null) {
            this.tioClusterConfig.getTioClusterTopic().addMessageListener(new TioClusterMessageListener(this));
        }
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public IpStatListener getIpStatListener() {
        return this.ipStatListener;
    }

    public void setIpStatListener(IpStatListener ipStatListener) {
        this.ipStatListener = ipStatListener;
    }

    public GroupStat getGroupStat() {
        return this.groupStat;
    }

    public void setUseQueueDecode(boolean useQueueDecode) {
        this.useQueueDecode = useQueueDecode;
    }

    public void setUseQueueSend(boolean useQueueSend) {
        this.useQueueSend = useQueueSend;
    }

    public abstract boolean isServer();

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public boolean isSsl() {
        return this.sslConfig != null;
    }
}

