/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.maintain.IpBlacklist;
import org.tio.core.ssl.SslConfig;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.ServerGroupStat;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.Json;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class ServerTioConfig
extends TioConfig {
    static Logger log = LoggerFactory.getLogger(ServerTioConfig.class);
    private AcceptCompletionHandler acceptCompletionHandler = null;
    private ServerAioHandler serverAioHandler = null;
    private ServerAioListener serverAioListener = null;
    private Thread checkHeartbeatThread = null;
    private boolean needCheckHeartbeat = true;
    private boolean isShared = false;

    public ServerTioConfig(ServerAioHandler serverAioHandler, ServerAioListener serverAioListener) {
        this(null, serverAioHandler, serverAioListener);
    }

    public ServerTioConfig(String name, ServerAioHandler serverAioHandler, ServerAioListener serverAioListener) {
        this(name, serverAioHandler, serverAioListener, null, null);
    }

    public ServerTioConfig(ServerAioHandler serverAioHandler, ServerAioListener serverAioListener, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this(null, serverAioHandler, serverAioListener, tioExecutor, groupExecutor);
    }

    public ServerTioConfig(String name, ServerAioHandler serverAioHandler, ServerAioListener serverAioListener, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        super(tioExecutor, groupExecutor);
        this.ipBlacklist = new IpBlacklist(this.id, this);
        this.init(name, serverAioHandler, serverAioListener, tioExecutor, groupExecutor);
    }

    private void init(String name, ServerAioHandler serverAioHandler, ServerAioListener serverAioListener, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.name = name;
        this.groupStat = new ServerGroupStat();
        this.acceptCompletionHandler = new AcceptCompletionHandler();
        this.serverAioHandler = serverAioHandler;
        this.serverAioListener = serverAioListener;
        this.checkHeartbeatThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
                while (ServerTioConfig.this.needCheckHeartbeat && !ServerTioConfig.this.isStopped()) {
                    long iv;
                    long iv1;
                    StringBuilder builder;
                    if (ServerTioConfig.this.heartbeatTimeout <= 0L) {
                        log.info("{}, \u7528\u6237\u53d6\u6d88\u4e86\u6846\u67b6\u5c42\u9762\u7684\u5fc3\u8df3\u68c0\u6d4b\uff0c\u5982\u679c\u4e1a\u52a1\u9700\u8981\uff0c\u8bf7\u7528\u6237\u81ea\u5df1\u53bb\u5b8c\u6210\u5fc3\u8df3\u68c0\u6d4b", (Object)ServerTioConfig.this.name);
                        break;
                    }
                    try {
                        Thread.sleep(ServerTioConfig.this.heartbeatTimeout);
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    long start = SystemTimer.currTime;
                    SetWithLock setWithLock = ServerTioConfig.this.connections;
                    Set set = null;
                    long start1 = 0L;
                    int count = 0;
                    ReentrantReadWriteLock.ReadLock readLock = setWithLock.readLock();
                    readLock.lock();
                    start1 = SystemTimer.currTime;
                    set = (Set)setWithLock.getObj();
                    for (ChannelContext channelContext : set) {
                        ++count;
                        long compareTime = Math.max(channelContext.stat.latestTimeOfReceivedByte, channelContext.stat.latestTimeOfSentPacket);
                        long currtime = SystemTimer.currTime;
                        long interval = currtime - compareTime;
                        boolean needRemove = false;
                        if (channelContext.heartbeatTimeout != null && channelContext.heartbeatTimeout > 0L) {
                            needRemove = interval > channelContext.heartbeatTimeout;
                        } else {
                            boolean bl = needRemove = interval > ServerTioConfig.this.heartbeatTimeout;
                        }
                        if (!needRemove || ServerTioConfig.this.serverAioListener.onHeartbeatTimeout(channelContext, interval, channelContext.stat.heartbeatTimeoutCount.incrementAndGet())) continue;
                        log.info("{}, {} ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f", (Object)channelContext, (Object)interval);
                        channelContext.setCloseCode(ChannelContext.CloseCode.HEARTBEAT_TIMEOUT);
                        Tio.remove(channelContext, interval + " ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f");
                    }
                    try {
                        readLock.unlock();
                        if (!ServerTioConfig.this.debug) continue;
                        builder = new StringBuilder();
                        builder.append("\r\n").append(ServerTioConfig.this.getName());
                        builder.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4:").append(SystemTimer.currTime);
                        builder.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570  :").append(((ServerGroupStat)ServerTioConfig.this.groupStat).accepted.get());
                        builder.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570            :").append(set.size());
                        builder.append("\r\n \u2502 \t \u251c \u5f02IP\u8fde\u63a5\u6570           :").append(((Map)ServerTioConfig.this.ips.getIpmap().getObj()).size());
                        builder.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570  :").append(ServerTioConfig.this.groupStat.closed.get());
                        builder.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f  :").append(ServerTioConfig.this.groupStat.handledPackets.get());
                        builder.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte):").append(ServerTioConfig.this.groupStat.receivedPackets.get()).append("/").append(ServerTioConfig.this.groupStat.receivedBytes.get());
                        builder.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte):").append(ServerTioConfig.this.groupStat.sentPackets.get()).append("/").append(ServerTioConfig.this.groupStat.sentBytes.get()).append("b");
                        builder.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570  :").append(ServerTioConfig.this.groupStat.getBytesPerTcpReceive());
                        builder.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305  :").append(ServerTioConfig.this.groupStat.getPacketsPerTcpReceive());
                        builder.append("\r\n \u2514 IP\u7edf\u8ba1\u65f6\u6bb5 ");
                        if (CollUtil.isNotEmpty(ServerTioConfig.this.ipStats.durationList)) {
                            builder.append("\r\n   \t \u2514 ").append(Json.toJson(ServerTioConfig.this.ipStats.durationList));
                        } else {
                            builder.append("\r\n   \t \u2514 ").append("\u6ca1\u6709\u8bbe\u7f6eip\u7edf\u8ba1\u65f6\u95f4");
                        }
                        builder.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c clientNodes :").append(((Map)ServerTioConfig.this.clientNodes.getObjWithLock().getObj()).size());
                        builder.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5               :").append(((Set)ServerTioConfig.this.connections.getObj()).size());
                        builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570         :").append(((Map)ServerTioConfig.this.users.getMap().getObj()).size());
                        builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570       :").append(((Map)ServerTioConfig.this.tokens.getMap().getObj()).size());
                        builder.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(((Map)ServerTioConfig.this.waitingResps.getObj()).size());
                        builder.append("\r\n \u251c \u7fa4\u7ec4");
                        builder.append("\r\n \u2502 \t \u2514 groupmap:").append(((Map)ServerTioConfig.this.groups.getGroupmap().getObj()).size());
                        builder.append("\r\n \u2514 \u62c9\u9ed1IP ");
                        builder.append("\r\n   \t \u2514 ").append(Json.toJson(ServerTioConfig.this.ipBlacklist.getAll()));
                        log.warn(builder.toString());
                        long end = SystemTimer.currTime;
                        iv1 = start1 - start;
                        iv = end - start1;
                        log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{ServerTioConfig.this.name, count, iv1, iv, ServerTioConfig.this.heartbeatTimeout});
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                    continue;
                    catch (Throwable e) {
                        try {
                            log.error("", e);
                        }
                        catch (Throwable throwable) {
                            try {
                                readLock.unlock();
                                if (ServerTioConfig.this.debug) {
                                    StringBuilder builder2 = new StringBuilder();
                                    builder2.append("\r\n").append(ServerTioConfig.this.getName());
                                    builder2.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4:").append(SystemTimer.currTime);
                                    builder2.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
                                    builder2.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570  :").append(((ServerGroupStat)ServerTioConfig.this.groupStat).accepted.get());
                                    builder2.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570            :").append(set.size());
                                    builder2.append("\r\n \u2502 \t \u251c \u5f02IP\u8fde\u63a5\u6570           :").append(((Map)ServerTioConfig.this.ips.getIpmap().getObj()).size());
                                    builder2.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570  :").append(ServerTioConfig.this.groupStat.closed.get());
                                    builder2.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
                                    builder2.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f  :").append(ServerTioConfig.this.groupStat.handledPackets.get());
                                    builder2.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte):").append(ServerTioConfig.this.groupStat.receivedPackets.get()).append("/").append(ServerTioConfig.this.groupStat.receivedBytes.get());
                                    builder2.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte):").append(ServerTioConfig.this.groupStat.sentPackets.get()).append("/").append(ServerTioConfig.this.groupStat.sentBytes.get()).append("b");
                                    builder2.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570  :").append(ServerTioConfig.this.groupStat.getBytesPerTcpReceive());
                                    builder2.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305  :").append(ServerTioConfig.this.groupStat.getPacketsPerTcpReceive());
                                    builder2.append("\r\n \u2514 IP\u7edf\u8ba1\u65f6\u6bb5 ");
                                    if (CollUtil.isNotEmpty(ServerTioConfig.this.ipStats.durationList)) {
                                        builder2.append("\r\n   \t \u2514 ").append(Json.toJson(ServerTioConfig.this.ipStats.durationList));
                                    } else {
                                        builder2.append("\r\n   \t \u2514 ").append("\u6ca1\u6709\u8bbe\u7f6eip\u7edf\u8ba1\u65f6\u95f4");
                                    }
                                    builder2.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
                                    builder2.append("\r\n \u2502 \t \u251c clientNodes :").append(((Map)ServerTioConfig.this.clientNodes.getObjWithLock().getObj()).size());
                                    builder2.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5               :").append(((Set)ServerTioConfig.this.connections.getObj()).size());
                                    builder2.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570         :").append(((Map)ServerTioConfig.this.users.getMap().getObj()).size());
                                    builder2.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570       :").append(((Map)ServerTioConfig.this.tokens.getMap().getObj()).size());
                                    builder2.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(((Map)ServerTioConfig.this.waitingResps.getObj()).size());
                                    builder2.append("\r\n \u251c \u7fa4\u7ec4");
                                    builder2.append("\r\n \u2502 \t \u2514 groupmap:").append(((Map)ServerTioConfig.this.groups.getGroupmap().getObj()).size());
                                    builder2.append("\r\n \u2514 \u62c9\u9ed1IP ");
                                    builder2.append("\r\n   \t \u2514 ").append(Json.toJson(ServerTioConfig.this.ipBlacklist.getAll()));
                                    log.warn(builder2.toString());
                                    long end = SystemTimer.currTime;
                                    long iv12 = start1 - start;
                                    long iv2 = end - start1;
                                    log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{ServerTioConfig.this.name, count, iv12, iv2, ServerTioConfig.this.heartbeatTimeout});
                                }
                            }
                            catch (Throwable e2) {
                                log.error("", e2);
                            }
                            throw throwable;
                        }
                        try {
                            readLock.unlock();
                            if (!ServerTioConfig.this.debug) continue;
                            builder = new StringBuilder();
                            builder.append("\r\n").append(ServerTioConfig.this.getName());
                            builder.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4:").append(SystemTimer.currTime);
                            builder.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570  :").append(((ServerGroupStat)ServerTioConfig.this.groupStat).accepted.get());
                            builder.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570            :").append(set.size());
                            builder.append("\r\n \u2502 \t \u251c \u5f02IP\u8fde\u63a5\u6570           :").append(((Map)ServerTioConfig.this.ips.getIpmap().getObj()).size());
                            builder.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570  :").append(ServerTioConfig.this.groupStat.closed.get());
                            builder.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f  :").append(ServerTioConfig.this.groupStat.handledPackets.get());
                            builder.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte):").append(ServerTioConfig.this.groupStat.receivedPackets.get()).append("/").append(ServerTioConfig.this.groupStat.receivedBytes.get());
                            builder.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte):").append(ServerTioConfig.this.groupStat.sentPackets.get()).append("/").append(ServerTioConfig.this.groupStat.sentBytes.get()).append("b");
                            builder.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570  :").append(ServerTioConfig.this.groupStat.getBytesPerTcpReceive());
                            builder.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305  :").append(ServerTioConfig.this.groupStat.getPacketsPerTcpReceive());
                            builder.append("\r\n \u2514 IP\u7edf\u8ba1\u65f6\u6bb5 ");
                            if (CollUtil.isNotEmpty(ServerTioConfig.this.ipStats.durationList)) {
                                builder.append("\r\n   \t \u2514 ").append(Json.toJson(ServerTioConfig.this.ipStats.durationList));
                            } else {
                                builder.append("\r\n   \t \u2514 ").append("\u6ca1\u6709\u8bbe\u7f6eip\u7edf\u8ba1\u65f6\u95f4");
                            }
                            builder.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c clientNodes :").append(((Map)ServerTioConfig.this.clientNodes.getObjWithLock().getObj()).size());
                            builder.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5               :").append(((Set)ServerTioConfig.this.connections.getObj()).size());
                            builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570         :").append(((Map)ServerTioConfig.this.users.getMap().getObj()).size());
                            builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570       :").append(((Map)ServerTioConfig.this.tokens.getMap().getObj()).size());
                            builder.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(((Map)ServerTioConfig.this.waitingResps.getObj()).size());
                            builder.append("\r\n \u251c \u7fa4\u7ec4");
                            builder.append("\r\n \u2502 \t \u2514 groupmap:").append(((Map)ServerTioConfig.this.groups.getGroupmap().getObj()).size());
                            builder.append("\r\n \u2514 \u62c9\u9ed1IP ");
                            builder.append("\r\n   \t \u2514 ").append(Json.toJson(ServerTioConfig.this.ipBlacklist.getAll()));
                            log.warn(builder.toString());
                            long end = SystemTimer.currTime;
                            iv1 = start1 - start;
                            iv = end - start1;
                            log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{ServerTioConfig.this.name, count, iv1, iv, ServerTioConfig.this.heartbeatTimeout});
                        }
                        catch (Throwable e3) {
                            log.error("", e3);
                        }
                    }
                }
            }
        }, "tio-timer-checkheartbeat-" + this.id + "-" + name);
        this.checkHeartbeatThread.setDaemon(true);
        this.checkHeartbeatThread.setPriority(1);
        this.checkHeartbeatThread.start();
    }

    public void useSsl(String keyStoreFile, String trustStoreFile, String keyStorePwd) throws Exception {
        if (StrUtil.isNotBlank((CharSequence)keyStoreFile) && StrUtil.isNotBlank((CharSequence)trustStoreFile)) {
            SslConfig sslConfig = SslConfig.forServer(keyStoreFile, trustStoreFile, keyStorePwd);
            this.setSslConfig(sslConfig);
        }
    }

    public void useSsl(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String passwd) throws Exception {
        SslConfig sslConfig = SslConfig.forServer(keyStoreInputStream, trustStoreInputStream, passwd);
        this.setSslConfig(sslConfig);
    }

    public AcceptCompletionHandler getAcceptCompletionHandler() {
        return this.acceptCompletionHandler;
    }

    @Override
    public AioHandler getAioHandler() {
        return this.getServerAioHandler();
    }

    @Override
    public AioListener getAioListener() {
        return this.getServerAioListener();
    }

    public ServerAioHandler getServerAioHandler() {
        return this.serverAioHandler;
    }

    public ServerAioListener getServerAioListener() {
        return this.serverAioListener;
    }

    public void setServerAioListener(ServerAioListener serverAioListener) {
        this.serverAioListener = serverAioListener;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public String toString() {
        return "ServerTioConfig [name=" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void share(ServerTioConfig tioConfig) {
        Class<ServerTioConfig> clazz = ServerTioConfig.class;
        synchronized (ServerTioConfig.class) {
            if (tioConfig == this) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.clientNodes = tioConfig.clientNodes;
            this.connections = tioConfig.connections;
            this.groups = tioConfig.groups;
            this.users = tioConfig.users;
            this.tokens = tioConfig.tokens;
            this.ids = tioConfig.ids;
            this.bsIds = tioConfig.bsIds;
            this.ipBlacklist = tioConfig.ipBlacklist;
            this.ips = tioConfig.ips;
            if (!tioConfig.isShared && !this.isShared) {
                this.needCheckHeartbeat = false;
            }
            if (tioConfig.isShared && !this.isShared) {
                this.needCheckHeartbeat = false;
            }
            if (!tioConfig.isShared && this.isShared) {
                tioConfig.needCheckHeartbeat = false;
            }
            tioConfig.isShared = true;
            this.isShared = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

