/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/
	
	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
	
	1. Definitions.
	
	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.
	
	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.
	
	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.
	
	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.
	
	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.
	
	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.
	
	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).
	
	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.
	
	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."
	
	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.
	
	2. Grant of Copyright License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.
	
	3. Grant of Patent License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.
	
	4. Redistribution.
	
	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:
	
	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.
	
	5. Submission of Contributions.
	
	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.
	
	6. Trademarks.
	
	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.
	
	7. Disclaimer of Warranty.
	
	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.
	
	8. Limitation of Liability.
	
	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.
	
	9. Accepting Warranty or Additional Liability.
	
	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.
	
	END OF TERMS AND CONDITIONS
	
	APPENDIX: How to apply the Apache License to your work
	
	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.
	
	   Copyright 2018 JFinal
	
	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at
	
	     http://www.apache.org/licenses/LICENSE-2.0
	
	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.http.common;

import org.tio.utils.SysConst;

/**
 * 本类直接摘自baseio: https://gitee.com/generallycloud/baseio<br>
 * 谢谢作者整理<br>
 *
 * @author tanyaowu
 *
 */
public enum HttpResponseStatus {

	/**
	 *初始的请求已经接受，客户应当继续发送请求的其余部分。（HTTP 1.1新）
	 */
	C100(100, "Continue", "100 Continue"),
	/**
	 *服务器将遵从客户的请求转换到另外一种协议（HTTP 1.1新）
	 */
	C101(101, "Switching Protocols", "101 Switching Protocols"),
	/**
	 *一切正常，对GET和POST请求的应答文档跟在后面。
	 */
	C200(200, "OK", "200 OK"),
	/**
	 *服务器已经创建了文档，Location头给出了它的URL。
	 */
	C201(201, "Created", "201 Created"),
	/**
	 *已经接受请求，但处理尚未完成。
	 */
	C202(202, "Accepted", "202 Accepted"),
	/**
	 *文档已经正常地返回，但一些应答头可能不正确，因为使用的是文档的拷贝（HTTP 1.1新）。
	 */
	C203(203, "Non-Authoritative Information", "203 Non-Authoritative Information"),
	/**
	 *没有新文档，浏览器应该继续显示原来的文档。如果用户定期地刷新页面，而Servlet可以确定用户文档足够新，这个状态代码是很有用的。
	 */
	C204(204, "No Content", "204 No Content"),
	/**
	 *没有新的内容，但浏览器应该重置它所显示的内容。用来强制浏览器清除表单输入内容（HTTP 1.1新）。
	 */
	C205(205, "Reset Content", "205 Reset Content"),
	/**
	 *客户发送了一个带有Range头的GET请求，服务器完成了它（HTTP 1.1新）。
	 */
	C206(206, "Partial Content", "206 Partial Content"),
	/**
	 *客户请求的文档可以在多个位置找到，这些位置已经在返回的文档内列出。如果服务器要提出优先选择，则应该在Location应答头指明。
	 */
	C300(300, "Multiple Choices", "300 Multiple Choices"),
	/**
	 *客户请求的文档在其他地方，新的URL在Location头中给出，浏览器应该自动地访问新的URL。
	 */
	C301(301, "Moved Permanently", "301 Moved Permanently"),
	/**
	 *类似于301，但新的URL应该被视为临时性的替代，而不是永久性的。注意，在HTTP1.0中对应的状态信息是“Moved Temporatily”。出现该状态代码时，浏览器能够自动访问新的URL，因此它是一个很有用的状态代码。注意这个状态代码有时候可以和301替换使用。例如，如果浏览器错误地请求http://host/~user（缺少了后面的斜杠），有的服务器 返回301，有的则返回302。严格地说，我们只能假定只有当原来的请求是GET时浏览器才会自动重定向。请参见307。
	 */
	C302(302, "Found", "302 Found"),
	/**
	 *类似于301/302，不同之处在于，如果原来的请求是POST，Location头指定的重定向目标文档应该通过GET提取（HTTP 1.1新）。
	 */
	C303(303, "See Other", "303 See Other"),
	/**
	 *客户端有缓冲的文档并发出了一个条件性的请求（一般是提供If-Modified-Since头表示客户只想比指定日期更新的文档）。服务器告 诉客户，原来缓冲的文档还可以继续使用。
	 */
	C304(304, "Not Modified", "304 Not Modified"),
	/**
	 *客户请求的文档应该通过Location头所指明的代理服务器提取（HTTP 1.1新）。
	 */
	C305(305, "Use Proxy", "305 Use Proxy"),
	/**
	 *和302 （Found）相同。许多浏览器会错误地响应302应答进行重定向，即使原来的请求是POST，即使它实际上只能在POST请求的应答是303时才能重定 向。由于这个原因，HTTP 1.1新增了307，以便更加清除地区分几个状态代码：当出现303应答时，浏览器可以跟随重定向的GET和POST请求；如果是307应答，则浏览器只 能跟随对GET请求的重定向。（HTTP 1.1新）
	 */
	C307(307, "Temporary Redirect", "307 Temporary Redirect"),
	/**
	 *请求出现语法错误。
	 */
	C400(400, "Bad Request", "400 Bad Request"),
	/**
	 *客户试图未经授权访问受密码保护的页面。应答中会包含一个WWW-Authenticate头，浏览器据此显示用户名字/密码对话框，然后在填 写合适的Authorization头后再次发出请求。
	 */
	C401(401, "Unauthorized", "401 Unauthorized"),
	/**
	 *资源不可用。服务器理解客户的请求，但拒绝处理它。通常由于服务器上文件或目录的权限设置导致。
	 */
	C403(403, "Forbidden", "403 Forbidden"),
	/**
	 *无法找到指定位置的资源。这也是一个常用的应答。
	 */
	C404(404, "Not Found", "404 Not Found"),
	/**
	 *请求方法（GET、POST、HEAD、DELETE、PUT、TRACE等）对指定的资源不适用。（HTTP 1.1新）
	 */
	C405(405, "Method Not Allowed", "405 Method Not Allowed"),
	/**
	 *指定的资源已经找到，但它的MIME类型和客户在Accpet头中所指定的不兼容（HTTP 1.1新）。
	 */
	C406(406, "Not Acceptable", "406 Not Acceptable"),
	/**
	 *类似于401，表示客户必须先经过代理服务器的授权。（HTTP 1.1新）
	 */
	C407(407, "Proxy Authentication Required", "407 Proxy Authentication Required"),
	/**
	 *在服务器许可的等待时间内，客户一直没有发出任何请求。客户可以在以后重复同一请求。（HTTP 1.1新）
	 */
	C408(408, "Request Timeout", "408 Request Timeout"),
	/**
	 *通常和PUT请求有关。由于请求和资源的当前状态相冲突，因此请求不能成功。（HTTP 1.1新）
	 */
	C409(409, "Conflict", "409 Conflict"),
	/**
	 *所请求的文档已经不再可用，而且服务器不知道应该重定向到哪一个地址。它和404的不同在于，返回407表示文档永久地离开了指定的位置，而 404表示由于未知的原因文档不可用。（HTTP 1.1新）
	 */
	C410(410, "Gone", "410 Gone"),
	/**
	 *服务器不能处理请求，除非客户发送一个Content-Length头。（HTTP 1.1新）
	 */
	C411(411, "Length Required", "411 Length Required"),
	/**
	 *请求头中指定的一些前提条件失败（HTTP 1.1新）。
	 */
	C412(412, "Precondition Failed", "412 Precondition Failed"),
	/**
	 *目标文档的大小超过服务器当前愿意处理的大小。如果服务器认为自己能够稍后再处理该请求，则应该提供一个Retry-After头（HTTP 1.1新）。
	 */
	C413(413, "Request Entity Too Large", "413 Request Entity Too Large"),
	/**
	 *URI太长（HTTP 1.1新）。
	 */
	C414(414, "Request URI Too Long", "414 Request URI Too Long"),
	/**
	 *服务器不能满足客户在请求中指定的Range头。（HTTP 1.1新）
	 */
	C416(416, "Requested Range Not Satisfiable", "416 Requested Range Not Satisfiable"),
	/**
	 *服务器遇到了意料不到的情况，不能完成客户的请求。
	 */
	C500(500, "Internal Server Error", "500 Internal Server Error"),
	/**
	 *服务器不支持实现请求所需要的功能。例如，客户发出了一个服务器不支持的PUT请求。
	 */
	C501(501, "Not Implemented", "501 Not Implemented"),
	/**
	 *服务器作为网关或者代理时，为了完成请求访问下一个服务器，但该服务器返回了非法的应答。
	 */
	C502(502, "Bad Gateway", "502 Bad Gateway"),
	/**
	 *服务器由于维护或者负载过重未能应答。例如，Servlet可能在数据库连接池已满的情况下返回503。服务器返回503时可以提供一个 Retry-After头。
	 */
	C503(503, "Service Unavailable", "503 Service Unavailable"),
	/**
	 *由作为代理或网关的服务器使用，表示不能及时地从远程服务器获得应答。（HTTP 1.1新）
	 */
	C504(504, "Gateway Timeout", "504 Gateway Timeout"),
	/**
	 *服务器不支持请求中所指明的HTTP版本。（HTTP 1.1新）
	 */
	C505(505, "HTTP Version Not Supported", "505 HTTP Version Not Supported");

	public static HttpResponseStatus getHttpStatus(int status) {
		HttpResponseStatus[] values = HttpResponseStatus.values();
		for (HttpResponseStatus v : values) {
			if (v.getStatus() == status) {
				return v;
			}
		}
		return C505;
	}

	public int status;

	public String description;

	public String headerText;

	public byte[] headerBinary;

	public String responseLine;

	public byte[] responseLineBinary;

	private HttpResponseStatus(int status, String description, String headerText) {
		this.status = status;
		this.description = description;
		this.headerText = headerText;
		this.headerBinary = headerText.getBytes();
		this.responseLine = "HTTP/1.1 " + headerText + SysConst.CRLF;
		this.responseLineBinary = responseLine.getBytes();
	}

	public String getDescription() {
		return description;
	}

	public byte[] getHeaderBinary() {
		return headerBinary;
	}

	public String getHeaderText() {
		return headerText;
	}

	public int getStatus() {
		return status;
	}

	/**
	 * @return the responseLineBinary
	 */
	public byte[] getResponseLineBinary() {
		return responseLineBinary;
	}

	/**
	 * @param responseLineBinary the responseLineBinary to set
	 */
	public void setResponseLineBinary(byte[] responseLineBinary) {
		this.responseLineBinary = responseLineBinary;
	}

}
