/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.ObjWithLock;

public class SetWithLock<T>
extends ObjWithLock<Set<T>> {
    private static final long serialVersionUID = -2305909960649321346L;
    private static final Logger log = LoggerFactory.getLogger(SetWithLock.class);

    public SetWithLock(Set<T> set) {
        super(set);
    }

    public SetWithLock(Set<T> set, ReentrantReadWriteLock lock) {
        super(set, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)this.getObj();
            boolean bl = set.add(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)this.getObj();
            set.clear();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            Set set = (Set)this.getObj();
            boolean bl = set.remove(t);
            return bl;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            Set set = (Set)this.getObj();
            int n = set.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }
}

