/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

import java.nio.ByteBuffer;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.websocket.common.WsPacket;

public class WsClientEncoder {
    private static Logger log = LoggerFactory.getLogger(WsClientEncoder.class);
    private static final Random reuseableRandom = new Random();

    public static ByteBuffer encode(WsPacket packet, TioConfig tioConfig, ChannelContext channelContext) {
        ByteBuffer buf;
        byte[] wsBody = packet.getBody();
        byte[][] wsBodies = packet.getBodys();
        int wsBodyLength = 0;
        if (wsBody != null) {
            wsBodyLength += wsBody.length;
        } else if (wsBodies != null) {
            for (byte[] bs : wsBodies) {
                wsBodyLength += bs.length;
            }
        }
        byte opcode = packet.getWsOpcode().getCode();
        byte b0 = (byte)(packet.isWsEof() ? -128 : 0);
        b0 = (byte)(b0 | opcode);
        int maskedByte = -128;
        if (wsBodyLength < 126) {
            buf = ByteBuffer.allocate(2 + wsBodyLength + 4);
            buf.put(b0);
            buf.put((byte)(wsBodyLength | maskedByte));
        } else if (wsBodyLength < 65535) {
            buf = ByteBuffer.allocate(4 + wsBodyLength + 4);
            buf.put(b0);
            buf.put((byte)(0x7E | maskedByte));
            ByteBufferUtils.writeUB2WithBigEdian((ByteBuffer)buf, (int)wsBodyLength);
        } else {
            buf = ByteBuffer.allocate(10 + wsBodyLength + 4);
            buf.put(b0);
            buf.put((byte)(0x7F | maskedByte));
            buf.position(buf.position() + 4);
            ByteBufferUtils.writeUB4WithBigEdian((ByteBuffer)buf, (long)wsBodyLength);
        }
        ByteBuffer maskkey = ByteBuffer.allocate(4);
        maskkey.putInt(reuseableRandom.nextInt());
        buf.put(maskkey.array());
        if (wsBody != null) {
            for (int i = 0; i < wsBody.length; ++i) {
                wsBody[i] = (byte)(wsBody[i] ^ maskkey.get(i % 4));
            }
        }
        if (wsBody != null && wsBody.length > 0) {
            buf.put(wsBody);
        } else if (wsBodies != null) {
            for (byte[] bs : wsBodies) {
                buf.put(bs);
            }
        }
        return buf;
    }
}

