/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.HttpResponseStatus;
import org.tio.server.intf.ServerAioHandler;
import org.tio.utils.hutool.StrUtil;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.common.WsServerDecoder;
import org.tio.websocket.common.WsServerEncoder;
import org.tio.websocket.common.WsSessionContext;
import org.tio.websocket.common.util.BASE64Util;
import org.tio.websocket.common.util.SHA1Util;
import org.tio.websocket.server.WsServerConfig;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsServerAioHandler
implements ServerAioHandler {
    private static Logger log = LoggerFactory.getLogger(WsServerAioHandler.class);
    private static final String NOT_FINAL_WEBSOCKET_PACKET_PARTS = "TIO_N_F_W_P_P";
    private static final String SEC_WEBSOCKET_KEY_SUFFIX = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final byte[] SEC_WEBSOCKET_KEY_SUFFIX_BYTES = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes();
    private WsServerConfig wsServerConfig;
    private IWsMsgHandler wsMsgHandler;

    public WsServerAioHandler(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler) {
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
    }

    public WsRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws AioDecodeException {
        WsSessionContext wsSessionContext = (WsSessionContext)channelContext.get();
        if (!wsSessionContext.isHandshaked()) {
            HttpRequest request = HttpRequestDecoder.decode((ByteBuffer)buffer, (int)limit, (int)position, (int)readableLength, (ChannelContext)channelContext, (HttpConfig)this.wsServerConfig);
            if (request == null) {
                return null;
            }
            HttpResponse httpResponse = WsServerAioHandler.updateWebSocketProtocol(request, channelContext);
            if (httpResponse == null) {
                throw new AioDecodeException("http\u534f\u8bae\u5347\u7ea7\u5230websocket\u534f\u8bae\u5931\u8d25");
            }
            wsSessionContext.setHandshakeRequest(request);
            wsSessionContext.setHandshakeResponse(httpResponse);
            WsRequest wsRequestPacket = new WsRequest();
            wsRequestPacket.setHandShake(true);
            return wsRequestPacket;
        }
        WsRequest websocketPacket = WsServerDecoder.decode((ByteBuffer)buffer, (ChannelContext)channelContext);
        if (websocketPacket != null) {
            if (!websocketPacket.isWsEof()) {
                ArrayList<WsRequest> parts = (ArrayList<WsRequest>)channelContext.getAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS);
                if (parts == null) {
                    parts = new ArrayList<WsRequest>();
                    channelContext.setAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS, parts);
                }
                parts.add(websocketPacket);
            } else {
                byte[] bodyBs;
                List parts = (List)channelContext.getAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS);
                if (parts != null) {
                    channelContext.setAttribute(NOT_FINAL_WEBSOCKET_PACKET_PARTS, null);
                    parts.add(websocketPacket);
                    WsRequest first = (WsRequest)parts.get(0);
                    websocketPacket.setWsOpcode(first.getWsOpcode());
                    int allBodyLength = 0;
                    for (WsRequest wsRequest : parts) {
                        allBodyLength += wsRequest.getBody().length;
                    }
                    byte[] allBody = new byte[allBodyLength];
                    Integer index = 0;
                    for (WsRequest wsRequest : parts) {
                        System.arraycopy(wsRequest.getBody(), 0, allBody, index, wsRequest.getBody().length);
                        index = index + wsRequest.getBody().length;
                    }
                    websocketPacket.setBody(allBody);
                }
                HttpRequest handshakeRequest = wsSessionContext.getHandshakeRequest();
                if (websocketPacket.getWsOpcode() != Opcode.BINARY && (bodyBs = websocketPacket.getBody()) != null) {
                    try {
                        String text = new String(bodyBs, handshakeRequest.getCharset());
                        websocketPacket.setWsBodyText(text);
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        return websocketPacket;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        WsResponse wsResponse = (WsResponse)packet;
        if (wsResponse.isHandShake()) {
            WsSessionContext imSessionContext = (WsSessionContext)channelContext.get();
            HttpResponse handshakeResponse = imSessionContext.getHandshakeResponse();
            try {
                return HttpResponseEncoder.encode((HttpResponse)handshakeResponse, (TioConfig)tioConfig, (ChannelContext)channelContext);
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.toString(), (Throwable)e);
                return null;
            }
        }
        ByteBuffer byteBuffer = WsServerEncoder.encode((WsResponse)wsResponse, (TioConfig)tioConfig, (ChannelContext)channelContext);
        return byteBuffer;
    }

    public WsServerConfig getHttpConfig() {
        return this.wsServerConfig;
    }

    private WsResponse h(WsRequest websocketPacket, byte[] bytes, Opcode opcode, ChannelContext channelContext) throws Exception {
        WsResponse wsResponse = null;
        if (opcode == Opcode.TEXT) {
            if (bytes == null || bytes.length == 0) {
                Tio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0cbody\u4e3a\u7a7a");
                return null;
            }
            String text = new String(bytes, this.wsServerConfig.getCharset());
            Object retObj = this.wsMsgHandler.onText(websocketPacket, text, channelContext);
            String methodName = "onText";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.BINARY) {
            if (bytes == null || bytes.length == 0) {
                Tio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0cbody\u4e3a\u7a7a");
                return null;
            }
            Object retObj = this.wsMsgHandler.onBytes(websocketPacket, bytes, channelContext);
            String methodName = "onBytes";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.PING || opcode == Opcode.PONG) {
            log.debug("\u6536\u5230" + opcode);
            return null;
        }
        if (opcode == Opcode.CLOSE) {
            Object retObj = this.wsMsgHandler.onClose(websocketPacket, bytes, channelContext);
            String methodName = "onClose";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        Tio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0c\u9519\u8bef\u7684Opcode");
        return null;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        WsRequest wsRequest = (WsRequest)packet;
        if (wsRequest.isHandShake()) {
            HttpResponse httpResponse;
            WsSessionContext wsSessionContext = (WsSessionContext)channelContext.get();
            HttpRequest request = wsSessionContext.getHandshakeRequest();
            HttpResponse r = this.wsMsgHandler.handshake(request, httpResponse = wsSessionContext.getHandshakeResponse(), channelContext);
            if (r == null) {
                Tio.remove((ChannelContext)channelContext, (String)"\u4e1a\u52a1\u5c42\u4e0d\u540c\u610f\u63e1\u624b");
                return;
            }
            wsSessionContext.setHandshakeResponse(r);
            WsResponse wsResponse = new WsResponse();
            wsResponse.setHandShake(true);
            Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
            wsSessionContext.setHandshaked(true);
            this.wsMsgHandler.onAfterHandshaked(request, httpResponse, channelContext);
            return;
        }
        if (!wsRequest.isWsEof()) {
            return;
        }
        WsResponse wsResponse = this.h(wsRequest, wsRequest.getBody(), wsRequest.getWsOpcode(), channelContext);
        if (wsResponse != null) {
            Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
        }
    }

    private WsResponse processRetObj(Object obj, String methodName, ChannelContext channelContext) throws Exception {
        WsResponse wsResponse = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            wsResponse = WsResponse.fromText((String)str, (String)this.wsServerConfig.getCharset());
            return wsResponse;
        }
        if (obj instanceof byte[]) {
            wsResponse = WsResponse.fromBytes((byte[])((byte[])obj));
            return wsResponse;
        }
        if (obj instanceof WsResponse) {
            return (WsResponse)obj;
        }
        if (obj instanceof ByteBuffer) {
            byte[] bs = ((ByteBuffer)obj).array();
            wsResponse = WsResponse.fromBytes((byte[])bs);
            return wsResponse;
        }
        log.error("{} {}.{}()\u65b9\u6cd5\uff0c\u53ea\u5141\u8bb8\u8fd4\u56debyte[]\u3001ByteBuffer\u3001WsResponse\u6216null\uff0c\u4f46\u662f\u7a0b\u5e8f\u8fd4\u56de\u4e86{}", new Object[]{channelContext, this.getClass().getName(), methodName, obj.getClass().getName()});
        return null;
    }

    public void setHttpConfig(WsServerConfig httpConfig) {
        this.wsServerConfig = httpConfig;
    }

    public static HttpResponse updateWebSocketProtocol(HttpRequest request, ChannelContext channelContext) {
        Map headers = request.getHeaders();
        String Sec_WebSocket_Key = (String)headers.get("sec-websocket-key");
        if (StrUtil.isNotBlank((CharSequence)Sec_WebSocket_Key)) {
            byte[] Sec_WebSocket_Key_Bytes = null;
            try {
                Sec_WebSocket_Key_Bytes = Sec_WebSocket_Key.getBytes(request.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] allBs = new byte[Sec_WebSocket_Key_Bytes.length + SEC_WEBSOCKET_KEY_SUFFIX_BYTES.length];
            System.arraycopy(Sec_WebSocket_Key_Bytes, 0, allBs, 0, Sec_WebSocket_Key_Bytes.length);
            System.arraycopy(SEC_WEBSOCKET_KEY_SUFFIX_BYTES, 0, allBs, Sec_WebSocket_Key_Bytes.length, SEC_WEBSOCKET_KEY_SUFFIX_BYTES.length);
            byte[] key_array = SHA1Util.SHA1((byte[])allBs);
            String acceptKey = BASE64Util.byteArrayToBase64((byte[])key_array);
            HttpResponse httpResponse = new HttpResponse(request);
            httpResponse.setStatus(HttpResponseStatus.C101);
            HashMap<HeaderName, HeaderValue> respHeaders = new HashMap<HeaderName, HeaderValue>();
            respHeaders.put(HeaderName.Connection, HeaderValue.Connection.Upgrade);
            respHeaders.put(HeaderName.Upgrade, HeaderValue.Upgrade.WebSocket);
            respHeaders.put(HeaderName.Sec_WebSocket_Accept, HeaderValue.from((String)acceptKey));
            httpResponse.addHeaders(respHeaders);
            return httpResponse;
        }
        return null;
    }
}

