/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.delegate;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.delegate.AbstractDatabaseDelegate;
import org.testcontainers.exception.ConnectionCreationException;
import org.testcontainers.ext.ScriptUtils;

public class CassandraDatabaseDelegate
extends AbstractDatabaseDelegate<Session> {
    private static final Logger log = LoggerFactory.getLogger(CassandraDatabaseDelegate.class);
    private final ContainerState container;

    protected Session createNewConnection() {
        try {
            return CassandraContainer.getCluster(this.container).newSession();
        }
        catch (DriverException e) {
            log.error("Could not obtain cassandra connection");
            throw new ConnectionCreationException("Could not obtain cassandra connection", (Throwable)e);
        }
    }

    public void execute(String statement, String scriptPath, int lineNumber, boolean continueOnError, boolean ignoreFailedDrops) {
        try {
            ResultSet result = ((Session)this.getConnection()).execute(statement);
            if (!result.wasApplied()) {
                throw new ScriptUtils.ScriptStatementFailedException(statement, lineNumber, scriptPath);
            }
            log.debug("Statement {} was applied", (Object)statement);
        }
        catch (DriverException e) {
            throw new ScriptUtils.ScriptStatementFailedException(statement, lineNumber, scriptPath, (Exception)((Object)e));
        }
    }

    protected void closeConnectionQuietly(Session session) {
        try {
            session.getCluster().close();
        }
        catch (Exception e) {
            log.error("Could not close cassandra connection", (Throwable)e);
        }
    }

    public CassandraDatabaseDelegate(ContainerState container) {
        this.container = container;
    }
}

