/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;

public interface ICellValueAndStyle {
    public void reset(int var1, Cell var2, Object var3, Column var4);

    public String getFileSuffix();

    public int getStyleIndex(int var1, Column var2, Object var3);

    default public void setCellValue(int row, Cell cell, Object e, Column hc, Class<?> clazz, boolean hasProcessor) {
        if (hasProcessor) {
            this.conversion(row, cell, e, hc);
            return;
        }
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        if (IWorksheetWriter.isString(clazz)) {
            cell.setSv(e.toString());
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            cell.setCv(((Character)e).charValue());
        } else if (IWorksheetWriter.isShort(clazz)) {
            cell.setNv(((Short)e).shortValue());
        } else if (IWorksheetWriter.isInt(clazz)) {
            cell.setNv((Integer)e);
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLv((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDv(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDv((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBv((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setMv((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setIv(DateUtil.toDateValue((LocalDate)e));
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setIv(DateUtil.toDateTimeValue((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setTv(DateUtil.toTimeValue((Time)e));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setTv(DateUtil.toTimeValue((LocalTime)e));
        } else {
            cell.setSv(e.toString());
        }
    }

    default public void setNullValue(int row, Cell cell, Column hc) {
        boolean hasIntProcessor;
        boolean bl = hasIntProcessor = hc.processor != null;
        if (hasIntProcessor) {
            this.conversion(row, cell, 0, hc);
        } else {
            cell.blank();
        }
    }

    default public void conversion(int row, Cell cell, Object o, Column hc) {
        Object e = hc.processor.conversion(o);
        if (e != null) {
            Class<?> clazz = e.getClass();
            if (IWorksheetWriter.isInt(clazz)) {
                if (IWorksheetWriter.isChar(clazz)) {
                    cell.setCv(((Character)e).charValue());
                } else if (IWorksheetWriter.isShort(clazz)) {
                    cell.setNv(((Short)e).shortValue());
                } else {
                    cell.setNv((Integer)e);
                }
            } else {
                this.setCellValue(row, cell, e, hc, clazz, false);
            }
        } else {
            cell.blank();
        }
    }
}

