/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.List;
import java.util.Map;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ListMapSheet
extends ListSheet<Map<String, ?>> {
    public ListMapSheet() {
    }

    public ListMapSheet(String name) {
        super(name);
    }

    public ListMapSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ListMapSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListMapSheet(List<Map<String, ?>> data) {
        this((String)null, data);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data) {
        super(name);
        this.setData(data);
    }

    public ListMapSheet(List<Map<String, ?>> data, Column ... columns) {
        this((String)null, data, columns);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data, Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListMapSheet(List<Map<String, ?>> data, WaterMark waterMark, Column ... columns) {
        this((String)null, data, waterMark, columns);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.left() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        while (this.start < end) {
            Row row = this.rowBlock.next();
            row.index = this.rows;
            Cell[] cells = row.realloc(len);
            for (int i = 0; i < len; ++i) {
                Column hc = this.columns[i];
                Object e = ((Map)this.data.get(this.start)).get(hc.key);
                Cell cell = cells[i];
                cell.clear();
                this.cellValueAndStyle.reset(this.rows, cell, e, hc);
            }
            ++this.rows;
            ++this.start;
        }
    }

    @Override
    protected Column[] getHeaderColumns() {
        block7: {
            Map first;
            block6: {
                if (this.headerReady) {
                    return this.columns;
                }
                first = (Map)this.getFirst();
                if (first != null) break block6;
                if (this.columns != null) break block7;
                this.columns = new Column[0];
                break block7;
            }
            if (!this.hasHeaderColumns()) {
                int size = first.size();
                int i = 0;
                this.columns = new Column[size];
                for (Map.Entry entry : first.entrySet()) {
                    if (StringUtil.isEmpty((String)entry.getKey())) continue;
                    Object value = entry.getValue();
                    this.columns[i++] = new Column((String)entry.getKey(), (String)entry.getKey(), value != null ? value.getClass() : String.class);
                }
            } else {
                for (int i = 0; i < this.columns.length; ++i) {
                    Column hc = this.columns[i];
                    if (StringUtil.isEmpty(hc.key)) {
                        throw new ExcelWriteException(this.getClass() + " must specify the 'key' name.");
                    }
                    if (hc.getClazz() != null) continue;
                    hc.setClazz(first.get(hc.key).getClass());
                }
            }
        }
        return this.columns;
    }
}

