/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ResultSetSheet
extends Sheet {
    protected ResultSet rs;

    public ResultSetSheet() {
    }

    public ResultSetSheet(String name) {
        super(name);
    }

    public ResultSetSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ResultSetSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public ResultSetSheet(ResultSet rs) {
        this(null, rs);
    }

    public ResultSetSheet(String name, ResultSet rs) {
        super(name);
        this.rs = rs;
    }

    public ResultSetSheet(ResultSet rs, Column ... columns) {
        this((String)null, rs, (WaterMark)null, columns);
    }

    public ResultSetSheet(String name, ResultSet rs, Column ... columns) {
        this(name, rs, (WaterMark)null, columns);
    }

    public ResultSetSheet(ResultSet rs, WaterMark waterMark, Column ... columns) {
        this(null, rs, waterMark, columns);
    }

    public ResultSetSheet(String name, ResultSet rs, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
        this.rs = rs;
    }

    public ResultSetSheet setRs(ResultSet rs) {
        this.rs = rs;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.shouldClose && this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                this.workbook.what("9006", e.getMessage());
            }
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        int len = this.columns.length;
        int n = 0;
        int limit = this.getRowLimit();
        try {
            int rbs = this.getRowBlockSize();
            while (n++ < rbs && this.rows < limit && this.rs.next()) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                Cell[] cells = row.realloc(len);
                for (int i = 1; i <= len; ++i) {
                    Object e;
                    SQLColumn hc = (SQLColumn)this.columns[i - 1];
                    Cell cell = cells[i - 1];
                    cell.clear();
                    switch (hc.sqlType) {
                        case -1: 
                        case 0: 
                        case 12: {
                            e = this.rs.getString(i);
                            break;
                        }
                        case -7: 
                        case -6: 
                        case 1: 
                        case 4: 
                        case 5: {
                            e = this.rs.getInt(i);
                            break;
                        }
                        case 91: {
                            e = this.rs.getDate(i);
                            break;
                        }
                        case 93: {
                            e = this.rs.getTimestamp(i);
                            break;
                        }
                        case 2: 
                        case 3: {
                            e = this.rs.getBigDecimal(i);
                            break;
                        }
                        case -5: {
                            e = this.rs.getLong(i);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            e = this.rs.getDouble(i);
                            break;
                        }
                        case 92: {
                            e = this.rs.getTime(i);
                            break;
                        }
                        default: {
                            e = this.rs.getObject(i);
                        }
                    }
                    this.cellValueAndStyle.reset(this.rows, cell, e, hc);
                }
                ++this.rows;
            }
        }
        catch (SQLException e) {
            throw new ExcelWriteException(e);
        }
        if (this.rows >= limit) {
            this.shouldClose = false;
            ResultSetSheet copy = (ResultSetSheet)this.getClass().cast(this.clone());
            this.workbook.insertSheet(this.id, copy);
        } else {
            this.shouldClose = true;
        }
    }

    @Override
    protected Column[] getHeaderColumns() {
        int i;
        if (this.headerReady) {
            return this.columns;
        }
        if (this.rs == null) {
            throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter ResultSet");
        }
        try {
            ResultSetMetaData metaData = this.rs.getMetaData();
            if (this.hasHeaderColumns()) {
                SQLColumn[] newColumns = new SQLColumn[this.columns.length];
                for (i = 0; i < this.columns.length; ++i) {
                    SQLColumn column;
                    newColumns[i] = column = SQLColumn.of(this.columns[i]);
                    if (StringUtil.isEmpty(column.getName())) {
                        column.setName(metaData.getColumnLabel(i + 1));
                    }
                    column.sqlType = metaData.getColumnType(i + 1);
                    Class<?> metaClazz = this.columnTypeToClass(column.sqlType);
                    if (column.clazz == metaClazz) continue;
                    this.what("The specified type " + column.clazz + " is different from metadata column type " + metaClazz);
                    column.clazz = metaClazz;
                }
                this.columns = newColumns;
            } else {
                int count = metaData.getColumnCount();
                this.columns = new Column[count];
                while (++i <= count) {
                    this.columns[i - 1] = new SQLColumn(metaData.getColumnLabel(i), metaData.getColumnType(i), this.columnTypeToClass(metaData.getColumnType(i)));
                }
            }
        }
        catch (SQLException e) {
            this.what("un-support get result set meta data.");
        }
        if (this.hasHeaderColumns()) {
            for (i = 0; i < this.columns.length; ++i) {
                if (!StringUtil.isEmpty(this.columns[i].getName())) continue;
                this.columns[i].setName(String.valueOf(i));
            }
        }
        return this.columns;
    }

    protected Class<?> columnTypeToClass(int type) {
        Class clazz;
        switch (type) {
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case 4: {
                clazz = Integer.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -7: {
                clazz = Boolean.class;
                break;
            }
            case -6: {
                clazz = Byte.class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case 7: {
                clazz = Float.class;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            default: {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    private static class SQLColumn
    extends Column {
        int sqlType;

        public SQLColumn(String name, int sqlType, Class<?> clazz) {
            super(name, clazz);
            this.sqlType = sqlType;
        }

        public static SQLColumn of(Column other) {
            SQLColumn self = new SQLColumn(other.name, 0, other.clazz);
            self.key = other.key;
            self.name = other.name;
            self.clazz = other.clazz;
            self.share = other.share;
            self.processor = other.processor;
            self.styleProcessor = other.styleProcessor;
            self.cellStyle = other.cellStyle;
            self.width = other.width;
            self.o = other.o;
            self.styles = other.styles;
            self.headerComment = other.headerComment;
            self.cellComment = other.cellComment;
            self.numFmt = other.numFmt;
            self.ignoreValue = other.ignoreValue;
            self.wrapText = other.wrapText;
            return self;
        }
    }
}

