/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.nio.file.Path;
import java.util.Arrays;
import org.ttzero.excel.entity.AbstractTemplate;
import org.ttzero.excel.entity.Workbook;

public class EmbedTemplate
extends AbstractTemplate {
    public EmbedTemplate(Path zipPath, Workbook wb) {
        super(zipPath, wb);
    }

    @Override
    protected boolean isPlaceholder(String txt) {
        int n = txt.indexOf(36);
        int len = txt.length();
        if (n == -1 || n == len - 1) {
            return false;
        }
        boolean has = false;
        do {
            if (txt.charAt(n + 1) != '{') continue;
            int m = txt.indexOf(125, n + 3);
            if (m < n) break;
            has = true;
            break;
        } while ((n = txt.indexOf(36, n + 1)) > -1 && n < len);
        return has;
    }

    @Override
    protected String getValue(String txt) {
        char[] values = txt.toCharArray();
        IntArray array = new IntArray();
        int n = txt.indexOf(36);
        int len = values.length;
        do {
            if (values[n + 1] != '{') continue;
            int m = txt.indexOf(125, n + 3);
            if (m < n) break;
            array.add(n, m);
            n = m;
        } while ((n = txt.indexOf(36, n + 1)) > -1 && n < len);
        StringBuilder buf = new StringBuilder();
        int offset = 0;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            int[] idx = array.get(i);
            String key = new String(values, idx[0] + 2, idx[1] - idx[0] - 2).trim();
            if (this.map.containsKey(key)) {
                buf.append(values, offset, idx[0] - offset).append((String)this.map.get(key));
            } else {
                buf.append(values, offset, idx[1] - offset + 1);
            }
            offset = idx[1] + 1;
        }
        if (offset < values.length) {
            buf.append(values, offset, values.length - offset);
        }
        return buf.toString();
    }

    private static final class IntArray {
        private int[] elements = new int[8];
        private int size;

        private IntArray() {
        }

        private int add(int i, int j) {
            int length = this.elements.length;
            int current = this.size;
            if (this.size + 1 >= length) {
                this.elements = Arrays.copyOf(this.elements, length << 1);
            }
            this.elements[this.size++] = i;
            this.elements[this.size++] = j;
            return current + 1;
        }

        private int size() {
            return this.size >> 1;
        }

        private int[] get(int index) {
            return new int[]{this.elements[index <<= 1], this.elements[index + 1]};
        }
    }
}

