/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import org.apache.axiom.om.util.Base64;

public class CipherMetaDataHolder {
    private String c;
    private String t = "RSA";
    private String tp;
    private String tpd;
    private String iv;

    public String getTransformation() {
        return this.t;
    }

    public void setTransformation(String transformation) {
        this.t = transformation;
    }

    public String getCipherText() {
        return this.c;
    }

    public byte[] getCipherBase64Decoded() {
        return Base64.decode((String)this.c);
    }

    public void setCipherText(String cipher) {
        this.c = cipher;
    }

    public String getThumbPrint() {
        return this.tp;
    }

    public void setThumbPrint(String tp) {
        this.tp = tp;
    }

    public String getThumbprintDigest() {
        return this.tpd;
    }

    public void setThumbprintDigest(String digest) {
        this.tpd = digest;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public byte[] getIvBase64Decoded() {
        return Base64.decode((String)this.iv);
    }

    public void setCipherBase64Encoded(byte[] cipher) {
        this.c = Base64.encode((byte[])cipher);
    }

    public void setThumbPrint(String tp, String digest) {
        this.tp = tp;
        this.tpd = digest;
    }

    public byte[] getSelfContainedCiphertextWithIv(byte[] originalCipher, byte[] iv) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        CipherInitializationVectorHolder cipherInitializationVectorHolder = new CipherInitializationVectorHolder();
        cipherInitializationVectorHolder.setCipher(Base64.encode((byte[])originalCipher));
        cipherInitializationVectorHolder.setInitializationVector(Base64.encode((byte[])iv));
        String cipherWithMetadataStr = gson.toJson((Object)cipherInitializationVectorHolder);
        return cipherWithMetadataStr.getBytes(Charset.defaultCharset());
    }

    public void setIvAndOriginalCipherText(byte[] cipherTextBytes) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String cipherStr = new String(cipherTextBytes, Charset.defaultCharset());
        CipherInitializationVectorHolder cipherInitializationVectorHolder = (CipherInitializationVectorHolder)gson.fromJson(cipherStr, CipherInitializationVectorHolder.class);
        this.setIv(cipherInitializationVectorHolder.getInitializationVector());
        this.setCipherText(cipherInitializationVectorHolder.getCipher());
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    private class CipherInitializationVectorHolder {
        private String cipher;
        private String initializationVector;

        private CipherInitializationVectorHolder() {
        }

        public String getCipher() {
            return this.cipher;
        }

        public void setCipher(String cipher) {
            this.cipher = cipher;
        }

        public String getInitializationVector() {
            return this.initializationVector;
        }

        public void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }
    }
}

