/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.api;

import java.security.cert.Certificate;
import org.wso2.carbon.crypto.api.CryptoContext;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.HybridEncryptionInput;
import org.wso2.carbon.crypto.api.HybridEncryptionOutput;

public interface CryptoService {
    public byte[] encrypt(byte[] var1, String var2, String var3) throws CryptoException;

    public byte[] decrypt(byte[] var1, String var2, String var3) throws CryptoException;

    public byte[] sign(byte[] var1, String var2, String var3, CryptoContext var4) throws CryptoException;

    public byte[] decrypt(byte[] var1, String var2, String var3, CryptoContext var4) throws CryptoException;

    public byte[] encrypt(byte[] var1, String var2, String var3, CryptoContext var4) throws CryptoException;

    public boolean verifySignature(byte[] var1, byte[] var2, String var3, String var4, CryptoContext var5) throws CryptoException;

    public Certificate getCertificate(CryptoContext var1) throws CryptoException;

    default public HybridEncryptionOutput hybridEncrypt(HybridEncryptionInput hybridEncryptionInput, String symmetricAlgorithm, String asymmetricAlgorithm, String javaSecurityProvider, CryptoContext cryptoContext) throws CryptoException {
        String errorMessage = "Hybrid encryption is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }

    default public byte[] hybridDecrypt(HybridEncryptionOutput hybridEncryptionOutput, String symmetricAlgorithm, String asymmetricAlgorithm, String javaSecurityProvider, CryptoContext cryptoContext) throws CryptoException {
        String errorMessage = "Hybrid decryption is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }

    default public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText) throws CryptoException {
        String errorMessage = "Encryption with self contained cipher text is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }

    default public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText, String internalCryptoProviderType) throws CryptoException {
        String errorMessage = "Encryption with providing internal crypto provider type is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }

    default public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider, String internalCryptoProviderType) throws CryptoException {
        String errorMessage = "decryption with providing internal crypto provider type is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }
}

