/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.deployment.Deployer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.component.xml.Component;
import org.wso2.carbon.utils.component.xml.ComponentConfigFactory;
import org.wso2.carbon.utils.component.xml.config.DeployerConfig;

public class Utils {
    private static final int BYTE_ARRAY_SIZE = 1024;
    private static Log log = LogFactory.getLog(Utils.class);

    private Utils() {
    }

    public static void transform(InputStream xmlStream, InputStream xslStream, OutputStream outputStream) throws TransformerException {
        StreamSource xmlStreamSource = new StreamSource(xmlStream);
        StreamSource xslStreamSource = new StreamSource(xslStream);
        StreamResult result = new StreamResult(outputStream);
        TransformerFactory factory = CarbonUtils.getSecureTransformerFactory();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer(xslStreamSource);
        transformer.transform(xmlStreamSource, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            String[] children;
            if (!targetLocation.exists() && !targetLocation.mkdir()) {
                throw new IOException("Fail to create the directory: " + targetLocation.getAbsolutePath());
            }
            for (String aChildren : children = sourceLocation.list()) {
                Utils.copyDirectory(new File(sourceLocation, aChildren), new File(targetLocation, aChildren));
            }
        } else {
            FileOutputStream out = null;
            FileInputStream in = new FileInputStream(sourceLocation);
            try {
                int len;
                out = new FileOutputStream(targetLocation);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to close the InputStream " + e.getMessage()), (Throwable)e);
                }
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to close the OutputStream " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public static void deployZipFile(File zipFileLocation, File targetLocation) throws CarbonException {
        try (JarFile jarFile = new JarFile(zipFileLocation);){
            TreeSet<String> dirsMade = new TreeSet<String>();
            Enumeration<JarEntry> all = jarFile.entries();
            while (all.hasMoreElements()) {
                Utils.getFile(all.nextElement(), jarFile, targetLocation, dirsMade);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while copying component", (Throwable)e);
            throw new CarbonException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getFile(ZipEntry zipEntry, JarFile zippy, File targetLocation, SortedSet<String> dirsMade) throws IOException {
        File d;
        String dirName;
        byte[] b = new byte[1024];
        String zipName = zipEntry.getName();
        if (zipName.startsWith("/")) {
            zipName = zipName.substring(1);
        }
        if (!zipName.startsWith("ui")) {
            return;
        }
        if ((zipName = zipName.substring(2)).endsWith("/")) {
            return;
        }
        int ix = zipName.lastIndexOf(47);
        if (!(ix <= 0 || dirsMade.contains(dirName = zipName.substring(0, ix)) || (d = new File(targetLocation, dirName)).exists() && d.isDirectory())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deploying Directory: " + dirName));
            }
            if (!d.mkdirs()) {
                log.warn((Object)("Warning: unable to mkdir " + dirName));
            }
            dirsMade.add(dirName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying " + zipName));
        }
        InputStream is = zippy.getInputStream(zipEntry);
        File file = new File(targetLocation, zipName);
        FileOutputStream os = null;
        try {
            int n;
            os = new FileOutputStream(file);
            while ((n = is.read(b)) > 0) {
                os.write(b, 0, n);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close the InputStream " + e.getMessage()), (Throwable)e);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close the OutputStream " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getWebContextName(BundleContext bundleContext) {
        String value;
        String webContext = "carbon";
        ServerConfiguration sc = ServerConfiguration.getInstance();
        if (sc != null && (value = sc.getFirstProperty("WebContext")) != null) {
            webContext = value;
        }
        return webContext;
    }

    public static void registerDeployerServices(BundleContext bundleContext) throws Exception {
        URL url = bundleContext.getBundle().getEntry("META-INF/component.xml");
        if (url == null) {
            return;
        }
        InputStream inputStream = url.openStream();
        Component component = ComponentConfigFactory.build(inputStream);
        DeployerConfig[] deployerConfigs = null;
        if (component != null) {
            deployerConfigs = (DeployerConfig[])component.getComponentConfig("deployers");
        }
        if (deployerConfigs != null) {
            for (DeployerConfig deployerConfig : deployerConfigs) {
                Class<?> deployerClass = null;
                try {
                    deployerClass = bundleContext.getBundle().loadClass(deployerConfig.getClassStr());
                }
                catch (ClassNotFoundException e) {
                    deployerClass = Class.forName(deployerConfig.getClassStr());
                }
                Deployer deployer = (Deployer)deployerClass.newInstance();
                String directory = deployerConfig.getDirectory();
                String extension = deployerConfig.getExtension();
                deployer.setDirectory(directory);
                deployer.setExtension(extension);
                Hashtable<String, String> propsMap = new Hashtable<String, String>(2);
                ((Dictionary)propsMap).put("directory", directory);
                ((Dictionary)propsMap).put("extension", extension);
                ((Dictionary)propsMap).put("org.apache.axis2.osgi.config.service", Deployer.class.getName());
                bundleContext.registerService(Deployer.class.getName(), (Object)deployer, propsMap);
            }
        }
    }
}

