/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wso2.carbon.utils.CarbonUtils;

public final class UserUtils {
    private static Log log = LogFactory.getLog(UserUtils.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public static boolean hasMultipleUserStores() throws Exception {
        String pathToUserMgtXML = CarbonUtils.getUserMgtXMLPath();
        if (pathToUserMgtXML == null || "".equals(pathToUserMgtXML)) {
            return false;
        }
        File file = new File(pathToUserMgtXML);
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = UserUtils.getSecuredDocumentBuilder();
            doc = docBuilderFactory.newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            log.error((Object)("Failed pasring config file " + pathToUserMgtXML + ". "), (Throwable)e);
            throw e;
        }
        NodeList userMgtConfig = doc.getElementsByTagName("UserStoreManager");
        return userMgtConfig != null && userMgtConfig.getLength() > 1;
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }
}

