/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.component.xml.Component;
import org.wso2.carbon.utils.component.xml.ComponentConfigFactory;
import org.wso2.carbon.utils.component.xml.config.DeployerConfig;

public class Axis2DeployerRegistry
implements BundleListener {
    private static Log log = LogFactory.getLog(Axis2DeployerRegistry.class);
    private DeploymentEngine deploymentEngine;
    private final Lock lock = new ReentrantLock();
    private Map<Bundle, Deployer> deployerMap = new HashMap<Bundle, Deployer>();

    public Axis2DeployerRegistry(AxisConfiguration axisConfiguration) {
        this.deploymentEngine = (DeploymentEngine)axisConfiguration.getConfigurator();
    }

    public void register(Bundle[] bundles, List<DeployerConfig> deployerConfigs) {
        for (Bundle bundle : bundles) {
            this.register(bundle);
        }
        for (DeployerConfig deployerConfig : deployerConfigs) {
            try {
                Deployer deployer = CarbonUtils.getDeployer(deployerConfig.getClassStr());
                this.addDeployer(deployerConfig, deployer);
            }
            catch (CarbonException e) {
                log.error((Object)("Error reading deployer: \"" + deployerConfig.getClassStr() + "\" from deployer configs"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Bundle bundle) {
        block13: {
            this.lock.lock();
            try {
                if (this.deployerMap.get(bundle) != null || bundle.getState() != 32) {
                    return;
                }
                URL url = bundle.getEntry("META-INF/component.xml");
                if (url == null) {
                    log.warn((Object)"Axis2Deployer header found in the MANIFEST : But no component.xml found in the bundle");
                    return;
                }
                InputStream inputStream = url.openStream();
                Component component = ComponentConfigFactory.build(inputStream);
                DeployerConfig[] deployerConfigs = null;
                if (component != null) {
                    deployerConfigs = (DeployerConfig[])component.getComponentConfig("deployers");
                }
                if (deployerConfigs == null) break block13;
                for (DeployerConfig deployerConfig : deployerConfigs) {
                    Class<?> deployerClass;
                    try {
                        deployerClass = bundle.loadClass(deployerConfig.getClassStr());
                    }
                    catch (ClassNotFoundException e) {
                        deployerClass = Class.forName(deployerConfig.getClassStr());
                    }
                    Deployer deployer = (Deployer)deployerClass.newInstance();
                    this.addDeployer(deployerConfig, deployer);
                    this.deployerMap.put(bundle, deployer);
                }
            }
            catch (Exception e) {
                String msg = "Error while deploying the Deployer from bunlde : " + bundle.getSymbolicName() + "-" + bundle.getVersion();
                log.error((Object)msg, (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addDeployer(DeployerConfig deployerConfig, Deployer deployer) {
        String directory = deployerConfig.getDirectory();
        String extension = deployerConfig.getExtension();
        deployer.setDirectory(directory);
        deployer.setExtension(extension);
        this.deploymentEngine.addDeployer(deployer, directory, extension);
    }

    public void unRegister(Bundle bundle) {
        this.lock.lock();
        this.lock.unlock();
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.unRegister(event.getBundle());
        }
    }
}

