/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.zalando.logbook.BaseHttpResponse;
import org.zalando.logbook.ForwardingBaseHttpResponse;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.RawHttpResponse;

final class BodyReplacementRawHttpResponse
implements ForwardingBaseHttpResponse,
RawHttpResponse {
    private final RawHttpResponse response;
    private final String replacement;

    public BodyReplacementRawHttpResponse(RawHttpResponse response, String replacement) {
        this.response = response;
        this.replacement = replacement;
    }

    public BaseHttpResponse delegate() {
        return this.response;
    }

    public HttpResponse withBody() throws IOException {
        this.response.withoutBody();
        return new BodyReplacementHttpResponse(this.response, this.replacement);
    }

    private static final class BodyReplacementHttpResponse
    implements ForwardingBaseHttpResponse,
    HttpResponse {
        private final RawHttpResponse response;
        private final String body;

        public BodyReplacementHttpResponse(RawHttpResponse response, String body) {
            this.response = response;
            this.body = body;
        }

        public BaseHttpResponse delegate() {
            return this.response;
        }

        public byte[] getBody() throws IOException {
            return this.body.getBytes(StandardCharsets.UTF_8);
        }

        public String getBodyAsString() throws IOException {
            return this.body;
        }
    }
}

