/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.BodyReplacer;
import org.zalando.logbook.Conditions;

@API(status=API.Status.STABLE)
public final class BodyReplacers {
    private BodyReplacers() {
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends BaseHttpMessage> BodyReplacer<T> defaultValue() {
        return BodyReplacer.compound((BodyReplacer[])new BodyReplacer[]{BodyReplacers.binary(), BodyReplacers.multipart(), BodyReplacers.stream()});
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends BaseHttpMessage> BodyReplacer<T> binary() {
        Predicate contentTypes = Conditions.contentType("application/octet-stream", "application/pdf", "audio/*", "image/*", "video/*");
        return BodyReplacers.replaceBody(contentTypes, "<binary>");
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends BaseHttpMessage> BodyReplacer<T> multipart() {
        return BodyReplacers.replaceBody(Conditions.contentType("multipart/*"), "<multipart>");
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends BaseHttpMessage> BodyReplacer<T> stream() {
        Predicate contentTypes = Conditions.contentType("application/json-seq", "application/x-json-stream", "application/stream+json", "text/event-stream");
        return BodyReplacers.replaceBody(contentTypes, "<stream>");
    }

    public static <T extends BaseHttpMessage> BodyReplacer<T> replaceBody(Predicate<T> predicate, String replacement) {
        return message -> predicate.test(message) ? replacement : null;
    }
}

