/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apiguardian.api.API;
import org.zalando.logbook.ChunkingSpliterator;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.DefaultLogbook;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RawHttpRequest;

@API(status=API.Status.EXPERIMENTAL)
public final class ChunkingHttpLogWriter
implements HttpLogWriter {
    private static final int MIN_MAX_DELTA = 16;
    private final int minChunkSize;
    private final int maxChunkSize;
    private final HttpLogWriter writer;

    public ChunkingHttpLogWriter(int size, HttpLogWriter writer) {
        if (size <= 0) {
            throw new IllegalArgumentException("size is expected to be greater than zero");
        }
        this.minChunkSize = size > 16 ? size - 16 : size;
        this.maxChunkSize = size;
        this.writer = writer;
    }

    public boolean isActive(RawHttpRequest request) throws IOException {
        return this.writer.isActive(request);
    }

    public void writeRequest(Precorrelation<String> precorrelation) {
        this.split((String)precorrelation.getRequest()).forEach(ChunkingHttpLogWriter.throwing(part -> this.writer.writeRequest(new DefaultLogbook.SimplePrecorrelation<String>(precorrelation.getId(), (String)part, precorrelation.getOriginalRequest()))));
    }

    public void writeResponse(Correlation<String, String> correlation) {
        this.split((String)correlation.getResponse()).forEach(ChunkingHttpLogWriter.throwing(part -> this.writer.writeResponse(new DefaultLogbook.SimpleCorrelation<Object, String>(correlation.getId(), correlation.getDuration(), correlation.getRequest(), (String)part, correlation.getOriginalRequest(), correlation.getOriginalResponse()))));
    }

    private static <T> Consumer<T> throwing(ThrowingConsumer<T> consumer) {
        return consumer;
    }

    private Stream<String> split(String string) {
        return StreamSupport.stream(new ChunkingSpliterator(string, this.minChunkSize, this.maxChunkSize), false);
    }

    private static interface ThrowingConsumer<T>
    extends Consumer<T> {
        public void tryAccept(@Nonnull T var1) throws Exception;

        @Override
        default public void accept(@Nonnull T t) {
            this.tryAccept(t);
        }
    }
}

