/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.Precorrelation;

@API(status=API.Status.STABLE)
public final class DefaultHttpLogFormatter
implements HttpLogFormatter {
    private static final Map<String, String> REASON_PHRASES;

    public String format(Precorrelation<HttpRequest> precorrelation) throws IOException {
        return this.format(this.prepare(precorrelation));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public List<String> prepare(Precorrelation<HttpRequest> precorrelation) throws IOException {
        HttpRequest request = (HttpRequest)precorrelation.getRequest();
        String requestLine = String.format("%s %s %s", request.getMethod(), request.getRequestUri(), request.getProtocolVersion());
        return this.prepare(request, "Request", precorrelation.getId(), requestLine);
    }

    public String format(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        return this.format(this.prepare(correlation));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public List<String> prepare(Correlation<HttpRequest, HttpResponse> correlation) throws IOException {
        HttpResponse response = (HttpResponse)correlation.getResponse();
        int status = response.getStatus();
        String reasonPhrase = REASON_PHRASES.getOrDefault(Integer.toString(status), "");
        String statusLine = String.format("%s %d %s", response.getProtocolVersion(), status, reasonPhrase).trim();
        return this.prepare((HttpMessage)response, "Response", correlation.getId(), "Duration: " + correlation.getDuration().toMillis() + " ms", statusLine);
    }

    private <H extends HttpMessage> List<String> prepare(H message, String type, String correlationId, String ... prefixes) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.direction(message) + " " + type + ": " + correlationId);
        Collections.addAll(lines, prefixes);
        lines.addAll(this.formatHeaders(message));
        String body = message.getBodyAsString();
        if (!body.isEmpty()) {
            lines.add("");
            lines.add(body);
        }
        return lines;
    }

    private String direction(HttpMessage request) {
        return request.getOrigin() == Origin.REMOTE ? "Incoming" : "Outgoing";
    }

    private List<String> formatHeaders(HttpMessage message) {
        return message.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::formatHeaderValues)).entrySet().stream().map(this::formatHeader).collect(Collectors.toList());
    }

    private String formatHeaderValues(Map.Entry<String, List<String>> entry) {
        return entry.getValue().stream().collect(Collectors.joining(", "));
    }

    private String formatHeader(Map.Entry<String, String> entry) {
        return String.format("%s: %s", entry.getKey(), entry.getValue());
    }

    @API(status=API.Status.EXPERIMENTAL)
    public String format(List<String> lines) {
        return lines.stream().collect(Collectors.joining("\n"));
    }

    static {
        HashMap<String, String> phrases = new HashMap<String, String>();
        phrases.put("100", "Continue");
        phrases.put("101", "Switching Protocols");
        phrases.put("102", "Processing");
        phrases.put("200", "OK");
        phrases.put("201", "Created");
        phrases.put("202", "Accepted");
        phrases.put("203", "Non-Authoritative Information");
        phrases.put("204", "No Content");
        phrases.put("205", "Reset Content");
        phrases.put("206", "Partial Content");
        phrases.put("207", "Multi-Status");
        phrases.put("208", "Already Reported");
        phrases.put("226", "IM Used");
        phrases.put("300", "Multiple Choices");
        phrases.put("301", "Moved Permanently");
        phrases.put("302", "Found");
        phrases.put("303", "See Other");
        phrases.put("304", "Not Modified");
        phrases.put("305", "Use Proxy");
        phrases.put("306", "Switch Proxy");
        phrases.put("307", "Temporary Redirect");
        phrases.put("308", "Permanent Redirect");
        phrases.put("400", "Bad Request");
        phrases.put("401", "Unauthorized");
        phrases.put("402", "Payment Required");
        phrases.put("403", "Forbidden");
        phrases.put("404", "Not Found");
        phrases.put("405", "Method Not Allowed");
        phrases.put("406", "Not Acceptable");
        phrases.put("407", "Proxy Authentication Required");
        phrases.put("408", "Request Timeout");
        phrases.put("409", "Conflict");
        phrases.put("410", "Gone");
        phrases.put("411", "Length Required");
        phrases.put("412", "Precondition Failed");
        phrases.put("413", "Payload Too Large");
        phrases.put("414", "URI Too Long");
        phrases.put("415", "Unsupported Media Type");
        phrases.put("416", "Requested Range Not Satisfiable");
        phrases.put("417", "Expectation Failed");
        phrases.put("418", "I'm a teapot");
        phrases.put("421", "Misdirected Request");
        phrases.put("422", "Unprocessable Entity");
        phrases.put("423", "Locked");
        phrases.put("424", "Failed Dependency");
        phrases.put("426", "Upgrade Required");
        phrases.put("428", "Precondition Required");
        phrases.put("429", "Too Many Requests");
        phrases.put("431", "Request Header Fields Too Large");
        phrases.put("444", "Connection Closed Without Response");
        phrases.put("451", "Unavailable For Legal Reasons");
        phrases.put("499", "Client Closed Request");
        phrases.put("500", "Internal Server Error");
        phrases.put("501", "Not Implemented");
        phrases.put("502", "Bad Gateway");
        phrases.put("503", "Service Unavailable");
        phrases.put("504", "Gateway Timeout");
        phrases.put("505", "HTTP Version Not Supported");
        phrases.put("506", "Variant Also Negotiates");
        phrases.put("507", "Insufficient Storage");
        phrases.put("508", "Loop Detected");
        phrases.put("510", "Not Extended");
        phrases.put("511", "Network Authentication Required");
        phrases.put("599", "Network Connect Timeout Error");
        REASON_PHRASES = Collections.unmodifiableMap(phrases);
    }
}

