/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RawHttpRequest;

@API(status=API.Status.STABLE)
public final class DefaultHttpLogWriter
implements HttpLogWriter {
    private final Logger logger;
    private final Predicate<Logger> activator;
    private final BiConsumer<Logger, String> consumer;

    public DefaultHttpLogWriter() {
        this(LoggerFactory.getLogger(Logbook.class));
    }

    public DefaultHttpLogWriter(Logger logger) {
        this(logger, Level.TRACE);
    }

    public DefaultHttpLogWriter(Logger logger, Level level) {
        this.logger = logger;
        this.activator = DefaultHttpLogWriter.chooseActivator(level);
        this.consumer = DefaultHttpLogWriter.chooseConsumer(level);
    }

    private static Predicate<Logger> chooseActivator(Level level) {
        switch (level) {
            case DEBUG: {
                return Logger::isDebugEnabled;
            }
            case INFO: {
                return Logger::isInfoEnabled;
            }
            case WARN: {
                return Logger::isWarnEnabled;
            }
            case ERROR: {
                return Logger::isErrorEnabled;
            }
        }
        return Logger::isTraceEnabled;
    }

    private static BiConsumer<Logger, String> chooseConsumer(Level level) {
        switch (level) {
            case DEBUG: {
                return Logger::debug;
            }
            case INFO: {
                return Logger::info;
            }
            case WARN: {
                return Logger::warn;
            }
            case ERROR: {
                return Logger::error;
            }
        }
        return Logger::trace;
    }

    Logger getLogger() {
        return this.logger;
    }

    public boolean isActive(RawHttpRequest request) {
        return this.activator.test(this.logger);
    }

    public void writeRequest(Precorrelation<String> precorrelation) {
        this.consumer.accept(this.logger, (String)precorrelation.getRequest());
    }

    public void writeResponse(Correlation<String, String> correlation) {
        this.consumer.accept(this.logger, (String)correlation.getResponse());
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

