/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpLogWriter;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.RawRequestFilter;
import org.zalando.logbook.RawResponseFilter;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;

final class DefaultLogbook
implements Logbook {
    private final Predicate<RawHttpRequest> predicate;
    private final RawRequestFilter rawRequestFilter;
    private final RawResponseFilter rawResponseFilter;
    private final RequestFilter requestFilter;
    private final ResponseFilter responseFilter;
    private final HttpLogFormatter formatter;
    private final HttpLogWriter writer;
    private final Clock clock = Clock.systemUTC();

    DefaultLogbook(Predicate<RawHttpRequest> predicate, RawRequestFilter rawRequestFilter, RawResponseFilter rawResponseFilter, RequestFilter requestFilter, ResponseFilter responseFilter, HttpLogFormatter formatter, HttpLogWriter writer) {
        this.predicate = predicate;
        this.rawRequestFilter = rawRequestFilter;
        this.rawResponseFilter = rawResponseFilter;
        this.requestFilter = requestFilter;
        this.responseFilter = responseFilter;
        this.formatter = formatter;
        this.writer = writer;
    }

    public Optional<Correlator> write(RawHttpRequest rawHttpRequest) throws IOException {
        Instant start = Instant.now(this.clock);
        if (this.writer.isActive(rawHttpRequest) && this.predicate.test(rawHttpRequest)) {
            String correlationId = DefaultLogbook.generateCorrelationId();
            RawHttpRequest filteredRawHttpRequest = this.rawRequestFilter.filter(rawHttpRequest);
            HttpRequest request = this.requestFilter.filter(filteredRawHttpRequest.withBody());
            SimplePrecorrelation<HttpRequest> precorrelation = new SimplePrecorrelation<HttpRequest>(correlationId, request, request);
            String formattedRequest = this.formatter.format(precorrelation);
            this.writer.writeRequest(new SimplePrecorrelation<String>(correlationId, formattedRequest, request));
            return Optional.of(rawHttpResponse -> {
                Instant end = Instant.now(this.clock);
                Duration duration = Duration.between(start, end);
                RawHttpResponse filteredRawHttpResponse = this.rawResponseFilter.filter(rawHttpResponse);
                HttpResponse response = this.responseFilter.filter(filteredRawHttpResponse.withBody());
                SimpleCorrelation<HttpRequest, HttpResponse> correlation = new SimpleCorrelation<HttpRequest, HttpResponse>(correlationId, duration, request, response, request, response);
                String formattedResponse = this.formatter.format(correlation);
                this.writer.writeResponse(new SimpleCorrelation<String, String>(correlationId, duration, formattedRequest, formattedResponse, request, response));
            });
        }
        return Optional.empty();
    }

    private static String generateCorrelationId() {
        return Long.toHexString(ThreadLocalRandom.current().nextLong() | Long.MIN_VALUE);
    }

    static class SimpleCorrelation<I, O>
    implements Correlation<I, O> {
        private final String id;
        private final Duration duration;
        private final I request;
        private final O response;
        private final HttpRequest originalRequest;
        private final HttpResponse originalResponse;

        SimpleCorrelation(String id, Duration duration, I request, O response, HttpRequest originalRequest, HttpResponse originalResponse) {
            this.id = id;
            this.duration = duration;
            this.request = request;
            this.response = response;
            this.originalRequest = originalRequest;
            this.originalResponse = originalResponse;
        }

        public String getId() {
            return this.id;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public I getRequest() {
            return this.request;
        }

        public O getResponse() {
            return this.response;
        }

        public HttpRequest getOriginalRequest() {
            return this.originalRequest;
        }

        public HttpResponse getOriginalResponse() {
            return this.originalResponse;
        }
    }

    static class SimplePrecorrelation<I>
    implements Precorrelation<I> {
        private final String id;
        private final I request;
        private final HttpRequest originalRequest;

        public SimplePrecorrelation(String id, I request, HttpRequest originalRequest) {
            this.id = id;
            this.request = request;
            this.originalRequest = originalRequest;
        }

        public String getId() {
            return this.id;
        }

        public I getRequest() {
            return this.request;
        }

        public HttpRequest getOriginalRequest() {
            return this.originalRequest;
        }
    }
}

